/*
 * $Id: log.c,v 1.5 2009-01-27 17:06:41 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include	<stdarg.h>
#include	<stdio.h>
#include	<stdlib.h>

#include	"glue-main.h"
#include	"log.h"

static int indent = 0;

void log_inc(void)
{
	indent++;
}

void log_dec(void)
{
	indent--;
}

void fatal_error(const char *msg,...)
{
	va_list	ap;

	fprintf(stderr, "INTERNAL ERROR: ");
	va_start(ap, msg);
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
	exit(1);
}

void logit(enum log_level level, const char *msg,...)
{
	va_list	ap;

	if (loglevel < level) {
		return;
	}

	switch(level) {
	case LOG_ERROR:
		fprintf(stderr, "ERROR:   ");
		break;
	case LOG_WARNING:
		fprintf(stderr, "WARNING: ");
		break;
	case LOG_NOTICE:
		fprintf(stderr, "NOTICE:  ");
		break;
	case LOG_DEBUG:
		fprintf(stderr, "DEBUG:   ");
		break;
	case LOG_DEBUG2:
		fprintf(stderr, "DEBUG2:  ");
		break;
	case LOG_DEBUG3:
		fprintf(stderr, "DEBUG3:  ");
		break;
	default:
		break;
	}
	for(level=0; level<indent; level++) {
		fprintf(stderr, "  ");
	}
	va_start(ap, msg);
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
}
