/*
 * $Id: sig_dio48.c,v 1.7 2009-01-27 17:06:41 potyra Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "sig_dio48.h"

struct sig_dio48 *
sig_dio48_init(const char *name, unsigned int nr)
{
	struct sig_dio48 *sig;
	char n[1000];
	unsigned int i;

	sig = shm_map(name, nr, sizeof(*sig), 0);

	for (i = 0; i < 48; i++) {
		sprintf(n, "%s-sig%02d", name, i);
		sig->sig[i] = sig_std_logic_init(n, nr);
	}

	return sig;
}

void
sig_dio48_create(const char *name, unsigned int nr)
{
	char n[1000];
	unsigned int i;

	shm_create(name, nr, sizeof(struct sig_dio48));

	for (i = 0; i < 48; i++) {
		sprintf(n, "%s-sig%02d", name, i);
		sig_std_logic_create(n, nr);
	}
}

void
sig_dio48_destroy(const char *name, unsigned int nr)
{
	char n[1000];
	unsigned int i;

	shm_destroy(name, nr);

	for (i = 0; i < 48; i++) {
		sprintf(n, "%s-sig%02d", name, i);
		sig_std_logic_destroy(n, nr);
	}
}
