/*
 * $Id: sig_manage.c,v 1.5 2009-01-27 17:06:41 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "sig_manage.h"

void
sig_manage_connect_port(
	struct sig_manage *b,
	const char *str,
	void *sig
)
{
	unsigned int nr;

	for (nr = 0; nr < b->nmembers; nr++) {
		if (! b->member[nr].f->connect) {
			continue;
		}
		(b->member[nr].f->connect)(b->member[nr].s, str, sig);
	}
}

void
sig_manage_disconnect_port(
	struct sig_manage *b,
	const char *str
)
{
	unsigned int nr;

	for (nr = 0; nr < b->nmembers; nr++) {
		if (! b->member[nr].f->disconnect) {
			continue;
		}
		(b->member[nr].f->disconnect)(b->member[nr].s, str);
	}
}

void
sig_manage_connect(
	struct sig_manage *b,
	void *s,
	const struct sig_manage_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_MANAGE);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));
	assert(s);
	assert(f);

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;

	b->nmembers++;
}

struct sig_manage *
sig_manage_init(const char *name, unsigned int nr)
{
	struct sig_manage *b;

	b = malloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_MANAGE;
	b->nmembers = 0;

	return b;
}

void
sig_manage_create(const char *name, unsigned int nr)
{
}

void
sig_manage_destroy(const char *name, unsigned int nr)
{
}
