/* $Id: sig_serial.h,v 1.10 2009-01-27 17:44:20 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_SERIAL_H_INCLUDED
#define __SIG_SERIAL_H_INCLUDED

#include <inttypes.h>
#include "sig_gen.h"

struct sig_serial_funcs {
	void (*recv)(void *s, uint8_t c);
};

struct sig_serial {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_serial_funcs *f;
	} member[10];
	unsigned int nmembers;
};

extern void
sig_serial_send(struct sig_serial *b, void *s, uint8_t c);

extern void
sig_serial_connect(struct sig_serial *b, void *s,
		const struct sig_serial_funcs *f);

extern struct sig_serial *
sig_serial_init(const char *name, int nr);

extern void
sig_serial_create(const char *name, int nr);
extern void
sig_serial_destroy(const char *name, int nr);

#endif /* __SIG_SERIAL_H_INCLUDED */
