/*
 * $Id: gui-gtk.h,v 1.4 2009-01-28 12:13:00 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GUI_GTK_H_INCLUDED
#define __GUI_GTK_H_INCLUDED

#include <gtk/gtk.h>

/* Standard gettext macros. */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

/* Functions */
void
gui_comp_add(
	unsigned int page,
	const char *comp_type,
	unsigned int comp_index,
	const char *comp_name,
	GtkWidget *main,
	int expand,
	int fill,
	GtkWidget *fi
);

extern gboolean
key_press_event(GtkWidget *widget, GdkEventKey *key_event, gpointer user_data);
extern gboolean
key_release_event(GtkWidget *widget, GdkEventKey *key_event, gpointer user_data);
extern gboolean
pointer_motion_event(GtkWidget *widget, GdkEventMotion *event, gpointer user_data);
extern gboolean
pointer_press_event(GtkWidget *widget, GdkEventButton *event, gpointer user_data);
extern gboolean
pointer_scroll_event(GtkWidget *widget, GdkEventScroll *event, gpointer user_data);

#endif /* __XGUI_GTK_H_INCLUDED */
