/*
 * $Id: entry.S,v 1.162 2009-02-19 19:20:36 vrsieh Exp $
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "build_config.h"
#include "libsys.h"
#include "compiler.h"

/* FIXME JOSEF: move gdt stuff to protected_mode.c */

.section .text, "ax"
.code16gcc


/* FIXME */
#ifndef CONFIG_80286_SUPPORT
#define OFF_WRT_CS(reg, lin_addr)			\
	/* Calculate offset to lin addr */		\
	xorl %reg, %reg;				\
	movl %cs, %reg;					\
	shll $4, %reg;					\
	subl $lin_addr, %reg;				\
	negl %reg;
#else
#define WRT_REG(reg, addr)				\
	movw $addr, %reg;
#endif


#define PCI_ADDR(bus, dev, func) \
	(((bus) << 16) | ((dev) << 11) | ((func) << 8))
#define PCICONF_ADDR	0x0cf8
#define PCICONF_DATA	0x0cfc

/* Pushes all registers on stack and calls the bios
 * function with a pointer to the registers 
 */
#ifndef CONFIG_80286_SUPPORT 
#define CALL() \
	/* pushl %eax; */ \
	pushl %ebx; \
	pushl %ecx; \
	pushl %edx; \
	pushw %bp; \
	pushw %si; \
	pushw %di; \
	\
	pushw %ds; \
	pushw %es; \
	\
	movw %ss, %dx; \
	movw %dx, %ds; \
	movw %dx, %es; \
	\
	movl %esp, %edx; \
	pushl %edx; \
	\
	andl $0x0000ffff, %esp; \
	andl $0x0000ffff, %edx; \
	pushl %edx; \
	\
	lcallw *%cs:(%eax); \
	\
	addw $4, %sp; \
	\
	popl %edx; \
	movl %edx, %esp; \
	\
	popw %es; \
	popw %ds; \
	\
	popw %di; \
	popw %si; \
	popw %bp; \
	popl %edx; \
	popl %ecx; \
	popl %ebx; \
	/* popl %eax */
#else
#define CALL() \
	/* pushw %es; */ \
	/* pushw %bx; */ \
	pushw %ax; \
	pushw %cx; \
	pushw %dx; \
	pushw %bp; \
	pushw %si; \
	pushw %di; \
	\
	pushw %ds; \
	\
	movw %ss, %dx; \
	movw %dx, %ds; \
	\
	pushw %es; \
	pushw %bx; \
	\
	movw %sp, %bp; \
	\
	lcallw *%ss:(%bp); \
	\
	addw $4, %sp; \
	\
	popw %ds; \
	\
	popw %di; \
	popw %si; \
	popw %bp; \
	popw %dx; \
	popw %cx; \
	popw %ax;
	/* popw %bx */
	/* popw %es; */
#endif

/* Saves registers on stack which might be modified
 * by the C-function and calls it with no parameters
 */
#ifndef CONFIG_80286_SUPPORT
#define IRQCALL() \
	/* pushl %eax; */ \
	pushl %ecx; \
	pushl %edx; \
	\
	pushw %ds; \
	pushw %es; \
	\
	movw %ss, %dx; \
	movw %dx, %ds; \
	movw %dx, %es; \
	\
	movl %esp, %edx; \
	pushl %edx; \
	\
	andl $0x0000ffff, %esp; \
	\
	lcallw *%cs:(%eax); \
	\
	popl %edx; \
	movl %edx, %esp; \
	\
	popw %es; \
	popw %ds; \
	\
	popl %edx; \
	popl %ecx; \
	/* popl %eax */
#else
#define IRQCALL() \
	/* pushw %es; */ \
	/* pushw %bx; */ \
	pushw %ax; \
	pushw %cx; \
	pushw %dx; \
	pushw %bp; \
	\
	pushw %ds; \
	\
	movw %ss, %dx; \
	movw %dx, %ds; \
	\
	pushw %es; \
	pushw %bx; \
	\
	movw %sp, %bp; \
	\
	lcallw *%ss:(%bp); \
	\
	addw $4, %sp; \
	\
	popw %ds; \
	\
	popw %bp; \
	popw %dx; \
	popw %cx; \
	popw %ax;
	/* popw %bx */
	/* popw %es; */
#endif

#ifndef CONFIG_80286_SUPPORT
#define CALLPM() \
	/* pushl %eax; */ \
	pushl %ebx; \
	pushl %ecx; \
	pushl %edx; \
	pushw %bp; \
	pushw %si; \
	pushw %di; \
	\
	pushw %ds; \
	pushw %es; \
	\
	movw %ss, %dx; \
	movw %dx, %ds; \
	movw %dx, %es; \
	\
	movl %esp, %edx; \
	pushl %edx; \
	call *%eax; \
	addw $4, %sp; \
	\
	popw %es; \
	popw %ds; \
	\
	popw %di; \
	popw %si; \
	popw %bp; \
	popl %edx; \
	popl %ecx; \
	popl %ebx; \
	/* popl %eax */
#else
#define CALLPM() \
	/* pushw %es; */ \
	/* pushw %bx; */ \
	pushw %ax; \
	pushw %cx; \
	pushw %dx; \
	pushw %bp; \
	pushw %si; \
	pushw %di; \
	\
	pushw %ds; \
	\
	movw %ss, %dx; \
	movw %dx, %ds; \
	\
	pushw %es; \
	pushw %bx; \
	\
	movw %sp, %bp; \
	\
	lcallw *%ss:(%bp); \
	\
	addw $4, %sp; \
	\
	popw %ds; \
	\
	popw %di; \
	popw %si; \
	popw %bp; \
	popw %dx; \
	popw %cx; \
	popw %ax;
	/* popw %bx */
	/* popw %es; */
#endif

#ifndef CONFIG_80286_SUPPORT
#define FAR_DATA_DEC(hl_handler)				\
far_data_ ## hl_handler:					\
	.word OFF_ ## hl_handler;				\
	.word SEG_ ## hl_handler;				
#else
#define FAR_DATA_DEC(hl_handler)
#endif

#ifndef CONFIG_80286_SUPPORT 
#define IRQ_HANDLER_STUB(name, hl_handler)			\
_C_LABEL(name): .globl _C_LABEL(name);				\
	pushl %eax;						\
	OFF_WRT_CS(eax, far_data_ ## hl_handler)		\
	jmp irq_common;
#else
#define IRQ_HANDLER_STUB(name, hl_handler)			\
_C_LABEL(name): .globl _C_LABEL(name);				\
	pushw %es;						\
	pushw %bx;						\
	WRT_REG(bx, SEG_ ## hl_handler)				\
	movw %bx, %es;						\
	WRT_REG(bx, OFF_ ## hl_handler)				\
	jmp irq_common;
#endif

#ifndef CONFIG_80286_SUPPORT 
#define BIOS_HANDLER_STUB(name, hl_handler)			\
_C_LABEL(name): .globl _C_LABEL(name);				\
	pushl %eax;						\
	OFF_WRT_CS(eax, far_data_ ## hl_handler)		\
	jmp sys_common;
#else
#define BIOS_HANDLER_STUB(name, hl_handler)			\
_C_LABEL(name): .globl _C_LABEL(name);				\
	pushw %es;						\
	pushw %bx;						\
	WRT_REG(bx, SEG_ ## hl_handler)				\
	movw %bx, %es;						\
	WRT_REG(bx, OFF_ ## hl_handler)				\
	jmp sys_common;
#endif

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

	.section .text.reset, "ax"
	.code16
	/* .org 0xfff0 */
#ifndef CONFIG_80286_SUPPORT 
	ex_ljmp reboot
#else
	ex_ljmp init_rm_bsp
#endif

	/* .org 0xfff5 */
	/* ASCII Date ROM was built - 8 characters in MM/DD/YY */
	.ascii "06/23/99"
	.byte 0

	/* .org 0xfffe */
	.byte 0xfc	/* SYS_MODEL_ID = AT */
	.byte 0


	.section .rodata
idt_descr: .globl idt_descr
	.word 256*8	/* 256 entries */
	.long 0
	.word 0		/* padding */

.section .text, "ax"

FAR_DATA_DEC(bios_08)
FAR_DATA_DEC(bios_09)
FAR_DATA_DEC(bios_0b)
FAR_DATA_DEC(bios_0c)
FAR_DATA_DEC(bios_0d)
FAR_DATA_DEC(bios_0e)
FAR_DATA_DEC(bios_0f)
FAR_DATA_DEC(bios_11_xxxx)
FAR_DATA_DEC(bios_12_xxxx)
FAR_DATA_DEC(bios_13_xxxx)
FAR_DATA_DEC(bios_14_xxxx)
FAR_DATA_DEC(bios_15_xxxx)
FAR_DATA_DEC(bios_16_xxxx)
FAR_DATA_DEC(bios_17_xxxx)
FAR_DATA_DEC(bios_18_xxxx)
FAR_DATA_DEC(bios_19_xxxx)
FAR_DATA_DEC(bios_1a_xxxx)
FAR_DATA_DEC(bios_70)
FAR_DATA_DEC(bios_71)
FAR_DATA_DEC(bios_72)
FAR_DATA_DEC(bios_73)
FAR_DATA_DEC(bios_74)
FAR_DATA_DEC(bios_75)
FAR_DATA_DEC(bios_76)
FAR_DATA_DEC(bios_77)
#ifdef CONFIG_ACPI_SUPPORT
FAR_DATA_DEC(bios_ff)
#endif
FAR_DATA_DEC(bios_dummy)
FAR_DATA_DEC(bios_exception)

	.code16gcc
/*
 * Exceptions
 */
BIOS_HANDLER_STUB(irq00, bios_exception)	/* divide by zero */
BIOS_HANDLER_STUB(irq01, bios_exception)	/* debug exception */
BIOS_HANDLER_STUB(irq02, bios_exception)	/* nmi interrupt */
BIOS_HANDLER_STUB(irq03, bios_exception)	/* breakpoint exception */
BIOS_HANDLER_STUB(irq04, bios_exception)	/* overflow exception */
BIOS_HANDLER_STUB(irq05, bios_exception)	/* bound range exceeded exception */
BIOS_HANDLER_STUB(irq06, bios_exception)	/* invalid opcode */
BIOS_HANDLER_STUB(irq07, bios_exception)	/* device not available exception */


/*
 * Interrupts 0x00 - 0x07
 */
IRQ_HANDLER_STUB(irq08, bios_08)	/* timer */
IRQ_HANDLER_STUB(irq09, bios_09)	/* keyboard */
					/* irq0a: Not used - cascade */
IRQ_HANDLER_STUB(irq0b, bios_0b)	/* rtc */
IRQ_HANDLER_STUB(irq0c, bios_0c)	/* ??? */
IRQ_HANDLER_STUB(irq0d, bios_0d)	/* ??? */
IRQ_HANDLER_STUB(irq0e, bios_0e)	/* floppy */
IRQ_HANDLER_STUB(irq0f, bios_0f)	/* parallel port */

/*
 * BIOS calls
 */
BIOS_HANDLER_STUB(irq11, bios_11_xxxx)
BIOS_HANDLER_STUB(irq12, bios_12_xxxx)
BIOS_HANDLER_STUB(irq13, bios_13_xxxx)
BIOS_HANDLER_STUB(irq14, bios_14_xxxx)
BIOS_HANDLER_STUB(irq15, bios_15_xxxx)
BIOS_HANDLER_STUB(irq16, bios_16_xxxx)
BIOS_HANDLER_STUB(irq17, bios_17_xxxx)
BIOS_HANDLER_STUB(irq18, bios_18_xxxx)
BIOS_HANDLER_STUB(irq19, bios_19_xxxx)
BIOS_HANDLER_STUB(irq1a, bios_1a_xxxx)

_C_LABEL(irq1c): .globl _C_LABEL(irq1c)
	/*
	 * Shortcut.
	 * **Don't** call any C function. Will result in stack overflow!
	 */
	iretw

/*
 * Interrupts 0x08 - 0x0f
 */
IRQ_HANDLER_STUB(irq70, bios_70)	/* ??? */
IRQ_HANDLER_STUB(irq71, bios_71)	/* ??? */
IRQ_HANDLER_STUB(irq72, bios_72)	/* ??? */
IRQ_HANDLER_STUB(irq73, bios_73)	/* ??? */
IRQ_HANDLER_STUB(irq74, bios_74)	/* mouse */
IRQ_HANDLER_STUB(irq75, bios_75)	/* ??? */
IRQ_HANDLER_STUB(irq76, bios_76)	/* ??? */
IRQ_HANDLER_STUB(irq77, bios_77)	/* ??? */

#ifdef CONFIG_ACPI_SUPPORT
/*
 * APIC interrupts
 */
IRQ_HANDLER_STUB(irqff, bios_ff)	/* spurious apic irq */
#endif

/*
 * Dummy handler
 */
BIOS_HANDLER_STUB(irqdummy, bios_dummy)

sys_common:
	CALL()
#ifndef CONFIG_80286_SUPPORT
	popl %eax
#else
	popw %bx
	popw %es
#endif
	iretw

irq_common:
	IRQCALL()
#ifndef CONFIG_80286_SUPPORT
	popl %eax
#else
	popw %bx
	popw %es
#endif
	iretw

.section .text.apm
.code32

#ifdef CONFIG_APM_SUPPORT
_C_LABEL(bios_15_53xx_entry): .globl _C_LABEL(bios_15_53xx_entry)
	pushfw			/* flags */
	pushw $0		/* cs */
	pushw $0		/* eip */
	pushl %eax
	call 1f
1:	popl %eax
	addl $_C_LABEL(bios_15_53xx_pm)-1b, %eax
	CALLPM()
	popl %eax
	addw $2, %sp
	addw $2, %sp
	popfw
	lret
#endif

#ifdef CONFIG_PNP_SUPPORT
/*
 * For information see
 * "Plug and Play BIOS Specification -- Version 1.0a"
 */

#ifdef RUNTIME_RM

	.text
	.code16
	.globl pnp_real_mode_entry
pnp_real_mode_entry:
	pushfl
	pushl %esp
	jmp stack16;

	.text
	.code16
	.globl pnp_protected_mode_entry
pnp_protected_mode_entry:
	pushfl
	pushl %esp

	/* Fix Stack if it is 16bit. */
	pushl %eax
	mov %ss, %ax
	lar %eax, %eax
	test $0x00400000, %eax	/* Test Stack "Big" Flag */
	popl %eax
	jne stack32
stack16:
	andl $0x0000ffff, %esp	/* We will use code like 4(%esp). */
stack32:

	.code16gcc
	/*
	 * Save Registers
	 */
	pushw %ds
	pushw %es
	pushl %eax
	pushl %ecx
	pushl %edx
		/* Other registers will be saved by gcc automatically. */

	/* Use %ss segment for %ds/%es, too. Needed for gcc code. */
	mov %ss, %dx
	mov %dx, %ds
	mov %dx, %es

	/*
	 * Call Handler
	 *
	 * Offset to Parameter Block:
	 *	Far call:	2+2 byte
	 *	pushfl:		4
	 *	pushl %esp:	4
	 *	pushw %ds:	2
	 *	pushw %es:	2
	 *	pushl %eax:	4
	 *	pushl %ecx:	4
	 *	pushl %edx:	4
	 */
	leal 28(%esp), %edx
	movw (%edx), %ax

#ifdef CONFIG_DMI_SUPPORT

1:	cmpw $0x50, %ax
	jl 1f
	cmpw $0x5f, %ax
	jg 1f

	pushl %edx
	ex_lcall dmi_entry
	addl $4, %esp

	jmp done

#endif /* CONFIG_DMI_SUPPORT */

1:
	movw $0x0081, %ax	/* Function Not Supported */
done:

	/* Restore Registers */
		/* Other registers are restored by gcc automatically. */
	popl %edx
	popl %ecx
	movw %ax, (%esp)	/* Put return value into low word of %eax. */
	popl %eax
	popw %es
	popw %ds

	popl %esp
	popfl
	lretw

/*
 * Orignal Entry
 *
 * 0336460 24 50 6e 50 10 21 00 00 3e 00 00 0f 00 80 bd 00
 * 0336500 f0 58 bd 00 00 0f 00 00 00 00 00 00 f0 00 00 0f
 * 0336520 00
 */

	.section .rodata.table.pnp
	.align 16 
	.globl pnp
pnp:
	.byte '$', 'P', 'n', 'P' /* Signature */
	.byte (1 << 4) | (0 << 0) /* Version 1.0 */
	.byte pnp_end - pnp
	.word 0		 /* Control: 0 no change flag supported, yet */
	.byte 0		 /* Checksum - fixed by external tool. */
	.word 0		 /* Offset Change Flag */
	.word 0		 /* Segment Change Flag */
	.word OFF_pnp_real_mode_entry   /* Offset Real-Mode Code */
	.word SEG_pnp_real_mode_entry   /* Segment Real-Mode Code */
	.word 0		 /* Offset Protected Mode Code - FIXME */
	.long 0		 /* Base Protected Mode Code - FIXME */
	.long 0		 /* OEM Device Identifier */
	.word SEG_pnp_real_mode_entry   /* Segment Real-Mode Data */
	.long 0		 /* Base Protected Mode Data - FIXME */
pnp_end:

#endif /* RUNTIME_RM */
#endif /* CONFIG_PNP_SUPPORT */

.section .text.pci
.code32

#ifdef CONFIG_PCI_SUPPORT
_C_LABEL(bios_pci_pm_entry): .globl _C_LABEL(bios_pci_pm_entry)
	pushfw			/* flags */
	pushw $0		/* cs */
	pushw $0		/* eip */
	pushl %eax
	call 1f
1:	popl %eax
	addl $_C_LABEL(bios_pci_pm)-1b, %eax
	CALLPM()
	popl %eax
	addw $2, %sp
	addw $2, %sp
	popfw
	lret
#endif
/* FIXME JOSEF: this *must not* be in 0xe000 - 0xffff, but can be anywhere ->
 * move it to other ROM part
 */

.section .text.bios32

_C_LABEL(bios32_pm_entry): .globl _C_LABEL(bios32_pm_entry)
	pushfw			/* flags */
	pushw $0		/* cs */
	pushw $0		/* eip */
	pushl %eax
	call 1f
1:	popl %eax
	addl $_C_LABEL(bios32_pm)-1b, %eax
	CALLPM()
	popl %eax
	addw $2, %sp
	addw $2, %sp
	popfw
	lret

.section .text.org_ff065 /* Default int $10 handler */
	/* FIXME */
	iret


#endif /* RUNTIME_RM */
#ifdef INIT_RM
	.section .text
	.code16gcc
_C_LABEL(call_ext): .globl _C_LABEL(call_ext)
#ifndef CONFIG_80286_SUPPORT
	popl %edx	/* return address */
	popl %eax	/* parameter */

	pusha
#else
	popw %dx	/* return address - ip */
	popw %bx	/* return address - cs */
	popw %ax	/* parameter */

	pushaw
#endif

	pushw %cs
	callw 1f
1:
	popw %cx
	addw $2f-1b, %cx
	pushw %cx

	pushw %ax
	pushw $3
	lretw
2:
#ifndef CONFIG_80286_SUPPORT
	popa

	pushl %eax	/* parameter */
	pushl %edx	/* return address */
#else
	popaw

	pushw %ax	/* parameter */
	pushw %bx	/* return address - cs */
	pushw %dx	/* return address - ip */
#endif
	lretw
#endif /* INIT_RM */

#ifdef INIT_EARLY
	.section .text.reset, "ax"
	/* .org 0xfffffff0 */
	.code16
_C_LABEL(bios_entry): .globl _C_LABEL(bios_entry)
	jmp early_init_entry

	.section .text
	.code16gcc
early_init_entry: .globl early_init_entry
	/*
	 * test warm reset
	 */
	movb $0x0f, %al	/* read reset type */
	outb %al, $0x70
	inb $0x71, %al
	cmp $0x05, %al
	jnz mem_init
	movb $0x0f, %al /* set reset type to default value */
	outb %al, $0x70
	movb $0x00, %al
	outb %al, $0x71

	ljmpw *(0x0467)

mem_init:
	/*
	 * Init Memory
	 *
	 * See 82443BX Host Bridge Datasheet.
	 */
	movw $0, %cx	/* Counter for 8 registers to set. */
	movl $0, %esi	/* Up to that limit memory is found. */
	movl $0, %edi	/* Up to that limit memory is tested. */

mem_init_loop:
	/* Set register of host bridge to support as much memory as */
	/* possible (0x80 * 8 MByte) to be able to access/test it... */
	/* reg(0x60 + %cx) <= 0x80 */
	movl $PCI_ADDR(0, 0, 0) | 0x80000000 | 0x60, %eax
	orb %cl, %al
	andb $0xfc, %al
	movw $PCICONF_ADDR, %dx
	outl %eax, %dx
	movw %cx, %dx
	andw $0x03, %dx
	orw $PCICONF_DATA, %dx
	movb $0x80, %al
	outb %al, %dx

mem_init_test:
	movb $0x00, (%edi)
	cmpb $0x00, (%edi)
	jne mem_end_found
	movb $0xff, (%edi)
	cmpb $0xff, (%edi)
	jne mem_end_found
	movb $0x55, (%edi)
	cmpb $0x55, (%edi)
	jne mem_end_found
	movb $0xaa, (%edi)
	cmpb $0xaa, (%edi)
	jne mem_end_found

	addl $8*1024*1024, %edi

	movb $0x00, (%esi)
	movb $0xff, (%edi)
	cmpb $0x00, (%esi)
	je mem_init_test

mem_end_found:
	movl %edi, %eax
	shrl $23, %eax

	/* PCICONF_ADDR already set. */
	/* %dx already set. */
	outb %al, %dx

	movl %edi, %esi
	addw $1, %cx
	cmpw $8, %cx
	jne mem_init_loop

	/*
	 * Enable 1Mbyte BIOS.
	 */
	movl $PCI_ADDR(0, 7, 0) | 0x80000000 | 0x4c, %eax
	movw $PCICONF_ADDR, %dx
	outl %eax, %dx
	movw $PCICONF_DATA + 2, %dx
	inw %dx
	orw $(1 << 9) | (1 << 7) | (1 << 6), %ax
	outw %ax, %dx

	/*
	 * Copy BIOS INIT data to "vma_init_rm_data".
	 */
	movl $evma_init_rm_data, %ecx
	subl $vma_init_rm_data, %ecx
	movl $vma_init_rm_data, %edi
	movl $lma_init_rm_data, %esi
	rep movsb %ds:(%esi), %es:(%edi)

	/*
	 * Clear BIOS INIT bss at "vma_init_rm_bss".
	 */
	movl $evma_init_rm_bss, %ecx
	subl $vma_init_rm_bss, %ecx
	movl $vma_init_rm_bss, %edi
	movb $0, %al
	rep stosb %es:(%edi)

	/*
	 * Copy BIOS INIT part to 0x10000.
	 */
	movl $evma_init_rm, %ecx
	subl $vma_init_rm, %ecx
	movl $vma_init_rm, %edi
	movl $lma_init_rm, %esi
	rep movsb %ds:(%esi), %es:(%edi)

#ifdef CONFIG_SMI_SUPPORT
	/*
	 * Copy BIOS SMM redirect part to 0x38000.
	 */
	movl $evma_smi_redirect, %ecx
	subl $vma_smi_redirect, %ecx
	movl $vma_smi_redirect, %edi
	movl $lma_smi_redirect, %esi
	rep movsb %ds:(%esi), %es:(%edi)

	/*
	 * Open SMM space to be able to copy SMM part of BIOS to 0xa8000.
	 */
	movl $PCI_ADDR(0, 0, 0) | 0x80000000 | 0x70, %eax
	movw $PCICONF_ADDR, %dx
	outl %eax, %dx
	movw $PCICONF_DATA + 2, %dx
	movb $(1 << 6) | (1 << 3), %al
	outb %al, %dx

	/*
	 * Copy BIOS SMM part to 0xa8000.
	 */
	movl $evma_smi, %ecx
	subl $vma_smi, %ecx
	movl $vma_smi, %edi
	movl $lma_smi, %esi
	rep movsb %ds:(%esi), %es:(%edi)

	/*
	 * Lock SMM space.
	 */
	movl $PCI_ADDR(0, 0, 0) | 0x80000000 | 0x70, %eax
	movw $PCICONF_ADDR, %dx
	outl %eax, %dx
	movw $PCICONF_DATA + 2, %dx
	movb $(1 << 4) | (1 << 3), %al
	outb %al, %dx
#endif /* CONFIG_SMI_SUPPORT */

	/*
	 * Set PAM registers to be able to copy RUNTIME part of
	 * BIOS to 0xe0000-0xfffff.
	 */
	movl $PCI_ADDR(0, 0, 0) | 0x80000000 | 0x58, %eax
	movw $PCICONF_ADDR, %dx
	outl %eax, %dx
	movw $PCICONF_DATA, %dx
	movl $0x00003000, %eax
	outl %eax, %dx

	/*
	 * Set PAM registers to be able to copy RUNTIME part of
	 * BIOS to 0xe0000-0xfffff.
	 */
	movl $PCI_ADDR(0, 0, 0) | 0x80000000 | 0x58, %eax
	movw $PCICONF_ADDR, %dx
	outl %eax, %dx
	movw $PCICONF_DATA, %dx
	movl $0x00003000, %eax
	outl %eax, %dx
	movl $PCI_ADDR(0, 0, 0) | 0x80000000 | 0x5c, %eax
	movw $PCICONF_ADDR, %dx
	outl %eax, %dx
	movw $PCICONF_DATA, %dx
	movl $0x33330000, %eax
	outl %eax, %dx

	/*
	 * Copy BIOS RUNTIME part to 0xe0000-0xfffff.
	 */
	movl $evma_rt_legacy, %ecx
	subl $vma_rt_legacy, %ecx
	movl $vma_rt_legacy, %edi
	movl $lma_rt_legacy, %esi
	rep movsb %ds:(%esi), %es:(%edi)

	/*
	 * Set PAM registers to make BIOS RUNTIME part read-only.
	 */
	movl $PCI_ADDR(0, 0, 0) | 0x80000000 | 0x58, %eax
	movw $PCICONF_ADDR, %dx
	outl %eax, %dx
	movw $PCICONF_DATA, %dx
	inl %dx, %eax
	andl $0xfffffbff, %eax	/* WE bit of range 0xf0000-0xfffff. */
	outl %eax, %dx
	movl $PCI_ADDR(0, 0, 0) | 0x80000000 | 0x5c, %eax
	movw $PCICONF_ADDR, %dx
	outl %eax, %dx
	movw $PCICONF_DATA, %dx
	inl %dx, %eax
	andl $0xbbbbffff, %eax	/* WE bits of range 0xe0000-0xeffff. */
	outl %eax, %dx

	/*
	 * Jump to INIT part of BIOS.
	 * This changes %cs segment.
	 */
	ex_ljmp init_rm_bsp
#endif /* INIT_EARLY */

#ifdef INIT_RM
	.code16
	.section .text.head
#ifdef CONFIG_SMP_SUPPORT

init_rm_ap: .globl init_rm_ap
	mov $0, %ax
	mov %ax, %sp
	movl $evma_stack_ap-4, %esp

	pushl $0
	ex_lcall init_rm
	addl $4, %esp

	ex_ljmp init_halt

#endif /* CONFIG_SMP_SUPPORT */

#ifndef CONFIG_80286_SUPPORT
init_rm_bsp: .globl init_rm_bsp
	mov $0, %ax
	mov %ax, %sp
	movl $evma_stack_bsp-4, %esp

	pushl $1
	ex_lcall init_rm
	addl $4, %esp

	ex_ljmp init_boot
#else
init_rm_bsp: .globl init_rm_bsp
	/* FIXME ss:sp */
	mov $0x1000, %ax
	mov %ax, %ss
	mov $0x1000, %sp

	push $1
	ex_lcall init_rm
	add $2, %sp

	ex_ljmp init_boot
#endif

#endif /* INIT_RM */

#ifdef RUNTIME_RM
/*
 * CAUTION:
 * This must be part of RUNTIME_RM.
 * AP processors wait here during boot of OS.
 */
	.code16
	.section .text
init_halt: .globl init_halt
	cli
1:	hlt
	jmp 1b

#endif /* RUNTIME_RM */

#ifdef RUNTIME_RM
/*
 * CAUTION:
 *
 * This *must* be part of RUNTIME_RM.
 * It should be able to wipe INIT part of out of memory.
 */
	.code16
	.section .text
init_boot: .globl init_boot
	ex_lcall boot
	movzbl %al, %edx	/* Bootdev */

	/*
	 * Wipe Memory
	 * Preserve
	 *	IDT (0x0-0x3ff),
	 *	BDA (0x400-0x4ff),
	 *	bootsector (0x7c00-?),
	 *	BSP stack (?-0x10000), and
	 *	EBDA (0x9f000-0x9ffff).
	 */
	movw $0, %ax
	/* Clear memory in range [0x500-0x7c00). */
	movw $0, %bx
	movw %bx, %es
	movw $0x500, %di
	movw $(0x7c00-0x500)/2, %cx
	rep stosw %es:(%di)

	/* Clear memory in range [0x10000-0x9f000). */
	movw $0x1000, %bx
1:	movw %bx, %es
	movw $0, %di
	movw $16/2, %cx
	rep stosw %es:(%di)
	addw $1, %bx
	cmpw $0x9f00, %bx
	jb 1b

	/* ... - FIXME */

	/*
	 * Setup Registers and Start Bootsector
	 */
	/* Init segment registers. */
	movw $0, %ax
	movw %ax, %ss
	movw %ax, %ds
	movw %ax, %es
	movw %ax, %fs
	movw %ax, %gs

	/* Init general purpose registers. */
	movl $0, %ebp
	movl $0, %edi
	movl $0, %esi
		/* %edx: Bootdev: see above. */
	movl $0, %ecx
	movl $0, %ebx
	movl $0, %eax
	pushw $0x0002	/* Disabled Interrupts */
	pushw $0x0000	/* %cs */
	pushw $0x7c00	/* %ip */
	iretw

#endif /* RUNTIME_RM */
