/* $Id: main.c,v 1.209 2009-01-28 14:37:59 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* Must be before other includes */
#include "config.h"
#include "build_config.h"
#include "compiler.h"

#include "bios.lds.h"
#include "assert.h"
#include "fixme.h"
#include "debug.h"
#include "stdio.h"
#include "ptrace.h"
#include "io.h"
#include "var.h"
#include "video.h"
#include "parallel.h"
#include "serial.h"
#include "cmos.h"
#include "setup.h"
#include "traps.h"
#include "pci.h"
#include "kbd.h"
#include "apm.h"
#include "rtc.h"
#include "mem.h"
#include "mouse.h"
#include "hwconfig.h"
#include "smp.h"
#include "entry.h"
#include "disk.h"
#include "boot.h"
#include "const.h"

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM
CODE16;

/*
 * Timer tick.
 */
void
bios_08(void)
{
	rtc_tick();
	floppy_tick();

	eoi();

	asm volatile (
		"\tint $0x1c\n"
	);
}

void
bios_0b(void)
{
	fixme();
	eoi();
}

void
bios_0c(void)
{
	fixme();
	eoi();
}

void
bios_0d(void)
{
	fixme();
	eoi();
}

void
bios_70(void)
{
	eoi();
}

void
bios_71(void)
{
	fixme();
	eoi();
}

void
bios_72(void)
{
	fixme();
	eoi();
}

void
bios_73(void)
{
	fixme();
	eoi();
}

#ifndef CONFIG_MOUSE_SUPPORT
void
bios_74(void)
{
	fixme();
	eoi();
}
#endif

void
bios_75(void)
{
	fixme();
	eoi();
}

void
bios_76(void)
{
	uint16_t ax;

	/* Report IRQ */
	var_put(hd_irq, var_get(hd_irq) | 0xff);

	/* Read status to ACK interrupt */
	(void) inb(0x1f7);

	/* Signal EOI */
	eoi();

	/* Signal interrupt to OS */
	asm volatile (
		"int $0x15\n"
		: "=a" (ax)
		: "0" ((uint16_t) 0x9100)
	);
}

void
bios_77(void)
{
	uint16_t ax;

	/* Might be spurious interrupt *or* IDE interrupt. */

	/* Report IRQ */
	var_put(hd_irq, var_get(hd_irq) | 0xc0);

	/* Read status to ACK interrupt */
	(void) inb(0x177);

	/* Signal EOI */
	eoi();

	/* Signal interrupt to OS */
	asm volatile (
		"int $0x15\n"
		: "=a" (ax)
		: "0" ((uint16_t) 0x9100)
	);
}

void
bios_11_xxxx(struct regs *regs)
{
	AX = var_get(sys_conf);
}

void
bios_15_xxxx(struct regs *regs)
{
	DEBUGPRINT(80, "calling int 15 with AX %04x\n", AX);
	if (AH == 0x24) {
		/* A20 gate support. */
		bios_15_24xx(regs);

	} else if (AH == 0x4f) {
		/* Keyboard intercept. */
		/* Nothing to do... */
		F |= (1 << 0);	/* Set carry. */

#ifdef CONFIG_APM_SUPPORT
	} else if (AH == 0x53) {
		if (cmos_ext_get(apm)) {
			/* APM not present */
			AH = 0x86;	/* Function unsupported. */
			F |= (1 << 0);	/* Set carry. */
		} else {
			/* APM functions */
			bios_15_53xx(regs);
		}
#endif

	} else if (AH == 0x86) {
		/* Wait for CX:DX microseconds. */
		bios_15_86xx(regs);

	} else if (AH == 0x87) {
		/* get memory size */
		bios_15_87xx(regs);

	} else if (AH == 0x88) {
		/* get memory size */
		bios_15_88xx(regs);

	} else if (AH == 0x90) {
		/* Device busy interrupt. */
		/* Called by Int 16h when no key available */
		/* Nothing to do... */
		AH = 0x00;
		F &= ~(1 << 0);  /* Clear carry. */

	} else if (AH == 0x91) {
		/* Interrupt complete. */
		/* Called by Int 16h when key becomes available */
		/* Nothing to do... */
		AH = 0x00;
		F &= ~(1 << 0);  /* Clear carry. */

	} else if (AH == 0xc0) {
		/* Get BIOS config. */
		bios_15_c0xx(regs);

	} else if (AH == 0xc1) {
		/* Get BIOS EBDA segment. */
		ES = var_get(ebda_seg);
		F &= ~(1 << 0);	/* Clear carry. */

#ifdef CONFIG_MOUSE_SUPPORT
	} else if (AH == 0xc2) {
		/* Mouse subfunctions. */
		bios_15_c2xx(regs);
#endif

	} else if (AX == 0xe801) {
		/* get memory size */
		bios_15_e801(regs);

	} else if (AX == 0xe820) {
		/* get system memory map */
		bios_15_e820(regs);

	} else if (AX == 0xe881) {
		/* get memory size */
		bios_15_e881(regs);

	} else {
		/* Unknown sub-function. */
#if 0
		/*
		 * Don't call dprintf. dprintf will use outb to print
		 * characters to console. outb will lead to problems
		 * when executing bios code via vm86 mode. Emulator
		 * doesn't know what to do with outb to our debug
		 * port.
		 */
		dprintf("int $0x%02x: unknown sub-function 0x%04x\n", 0x15, AX);
#endif
		AH = 0x86;	/* Function unsupported. */
		F |= (1 << 0);	/* Set carry. */
	}
}

void
bios_1a_xxxx(struct regs *regs)
{
	if        (AH == 0x00) {
		bios_1a_00xx(regs);

	} else if (AH == 0x01) {
		bios_1a_01xx(regs);

	} else if (AH == 0x02) {
		bios_1a_02xx(regs);

	} else if (AH == 0x03) {
		bios_1a_03xx(regs);

	} else if (AH == 0x04) {
		bios_1a_04xx(regs);

	} else if (AH == 0x05) {
		bios_1a_05xx(regs);

	} else if (AH == 0x06) {
		bios_1a_06xx(regs);

	} else if (AH == 0x07) {
		bios_1a_07xx(regs);

	} else if (AH == 0xaf) {
		/* Unknown - e100 dos driver calls this - FIXME */
		F |= 0x00000001;	/* Error */
		AH = 0x86;		/* function not supported */

#ifdef CONFIG_PCI_SUPPORT
	} else if (AH == 0xb0) {
		bios_1a_b0xx(regs);

	} else if (AH == 0xb1) {
		bios_1a_b1xx(regs);
#endif

	} else {
		/* Unknown sub-function. */
		dprintf("int $0x%02x: unknown sub-function 0x%02x\n", 0x1a, AH);
		F |= 0x00000001;
	}
}

void
bios_1c_xxxx(struct regs *regs)
{
	/* Do nothing... */
}

#ifdef CONFIG_SMP_SUPPORT
void
bios_ff(struct regs *regs)
{
	apic_spv_irq();
}
#endif	

void __attribute__((__noreturn__))
reboot(void)
{
	if (var_get(reset) == 0x1234) {
		/*
		 * Warm Reboot
		 */
		/* Enable A20 Gate */
		outb(0x02, 0x0092);

		/* Issue a cpu only reset. */
		outb(0x04, 0x0cf9);

	} else {
		/*
		 * Cold Reboot
		 */
		/* Issue a system reset. */
		outb(0x06,0x0cf9);
	}

	/* Wait for reset coming... */
	for (;;);
}

#endif /* RUNTIME_RM */
/* ==================== RUNTIME_PM ==================== */
#ifdef RUNTIME_PM
CODE32;

/* Must be in range 0xe0000 - 0xf0000 in memory. */
const struct _32_ {
	char sig[4];
	unsigned long entry;
	unsigned char revision;
	unsigned char length;		/* In 16 byte blocks. */
	unsigned char checksum;
	unsigned char reserved[5];
} bios32 __attribute__((__aligned__(16), __section__(".table.bios32"))) = {
	{ '_', '3', '2', '_' },
	/* FIXME JOSEF */
	(unsigned long) bios32_pm_entry,
	0,
	sizeof(struct _32_) / 16,
	0xff,	/* Will be fixed by external tool. */
	{ 0, 0, 0, 0, 0 }
};

__attribute((section(".text.bios32"))) void
bios32_pm(struct regs *regs)
{
	if (EBX != 0x00000000) {
		AL = 0x81;	/* Unimplemented subfunction. */
		return;
	}

#ifdef CONFIG_PCI_SUPPORT
	if (EAX == (('$' << 0) | ('P' << 8) | ('C' << 16) | ('I' << 24))) {
		/* PCI BIOS */
		unsigned long pci_pm_base;
		unsigned long entry_off;

		pci_pm_base = (unsigned long) vma_rt_pm_pci_text;
		entry_off = (unsigned long) bios_pci_pm_entry - pci_pm_base;

		AL = 0x00;
		EBX = pci_pm_base;		/* Physical addr. of service. */
		ECX = 0x00000000;		/* Length of service. */
		EDX = entry_off;		/* Entry point of service. */

	} else
#endif
	{
		/* Unknown service. */
		AL = 0x80;
	}
}

#endif /* RUNTIME_PM */
