/* $Id: cd_image.h,v 1.25 2009-01-28 13:57:48 potyra Exp $ 
 *
 * File for saving the image structure
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <inttypes.h>

/*
 * increment Version if there was a change which make old images no longer readable by
 * faumachine; it should always possible to convert it back to .iso with the cli tool
 */
#define FAUM_IMG_VERSION 8

/* here goes the stuff from the inner groove and other
 * media descriptor stuff */
typedef struct {
	/* the first 5 values should never change */
	char magic[13];
	uint32_t version; /* versionsnummer */
	int32_t offset; /* to own virtual toc */
	uint32_t total_blocks;
	uint16_t toc_size;

	/* atip-data mmc 64 */
	uint8_t writing_power;
	uint8_t reference_speed;
	uint8_t unrestricted_use;
	uint8_t media_type; /* also eraseable bit for read disc info */
	uint8_t start_of_leadin_m;
	uint8_t start_of_leadin_s;
	uint8_t start_of_leadin_f;
	uint8_t last_possible_start_of_leadout_m;
	uint8_t last_possible_start_of_leadout_s;
	uint8_t last_possible_start_of_leadout_f;
	int8_t disc_status; /* 0 empty, 1 incomplete/appendable, 2 complete */
	int8_t last_session_status; /* 0 empty, 1 incomplete, 3 complete */
} cd_image;

typedef struct { /* scsi-3 mmc P.15 */
	char data[2048];
	char auxfield[288]; /* edc,0 and ecc */
	char sync[11]; /* 12 - 1 */
	char header[4];
	uint8_t typeoftrack:4; /* mmc-2 table 7 page 17 */
	uint8_t datablocktype:4; /* mmc-2 table 126 page 113 */
} mode1;

typedef struct { /* mentoined at scsi mmc-2 P.50 */
	uint32_t fixed_packet_size:24;
	char tracktype; /* 01h audio tao, 02h data tao, 03h variable, 04h fixed */
} tdb;

typedef struct { /* scsi-3 mmc P.12 & P.61 */
	uint32_t blkcount;
	tdb trackdescblock;
	uint8_t reserved;
	uint8_t tno;
	uint8_t point;
	uint8_t min;
	uint8_t sec;
	uint8_t frame;
	uint8_t zero;
	uint8_t pmin;
	uint8_t psec;
	uint8_t pframe;
	uint8_t datablocktype; /* mmc-2 table 126 page 113 */
	uint8_t ctrl:4;
	uint8_t adr:4;
} toc_entry;

typedef struct { /* scsi-3 mmc P.12 & P.61 */
	toc_entry x01;
	toc_entry x02;
	toc_entry x03;
	toc_entry x04;
	toc_entry x05;
	toc_entry x06;
	toc_entry x07;
	toc_entry x08;
	toc_entry x09;
	toc_entry x0A;
	toc_entry x0B;
	toc_entry x0C;
	toc_entry x0D;
	toc_entry x0E;
	toc_entry x0F;
	toc_entry x10;
	toc_entry x11;
	toc_entry x12;
	toc_entry x13;
	toc_entry x14;
	toc_entry x15;
	toc_entry x16;
	toc_entry x17;
	toc_entry x18;
	toc_entry x19;
	toc_entry x1A;
	toc_entry x1B;
	toc_entry x1C;
	toc_entry x1D;
	toc_entry x1E;
	toc_entry x1F;
	toc_entry x20;
	toc_entry x21;
	toc_entry x22;
	toc_entry x23;
	toc_entry x24;
	toc_entry x25;
	toc_entry x26;
	toc_entry x27;
	toc_entry x28;
	toc_entry x29;
	toc_entry x2A;
	toc_entry x2B;
	toc_entry x2C;
	toc_entry x2D;
	toc_entry x2E;
	toc_entry x2F;
	toc_entry x30;
	toc_entry x31;
	toc_entry x32;
	toc_entry x33;
	toc_entry x34;
	toc_entry x35;
	toc_entry x36;
	toc_entry x37;
	toc_entry x38;
	toc_entry x39;
	toc_entry x3A;
	toc_entry x3B;
	toc_entry x3C;
	toc_entry x3D;
	toc_entry x3E;
	toc_entry x3F;
	toc_entry x40;
	toc_entry x41;
	toc_entry x42;
	toc_entry x43;
	toc_entry x44;
	toc_entry x45;
	toc_entry x46;
	toc_entry x47;
	toc_entry x48;
	toc_entry x49;
	toc_entry x4A;
	toc_entry x4B;
	toc_entry x4C;
	toc_entry x4D;
	toc_entry x4E;
	toc_entry x4F;
	toc_entry x50;
	toc_entry x51;
	toc_entry x52;
	toc_entry x53;
	toc_entry x54;
	toc_entry x55;
	toc_entry x56;
	toc_entry x57;
	toc_entry x58;
	toc_entry x59;
	toc_entry x5A;
	toc_entry x5B;
	toc_entry x5C;
	toc_entry x5D;
	toc_entry x5E;
	toc_entry x5F;
	toc_entry x60;
	toc_entry x61;
	toc_entry x62;
	toc_entry x63;
	toc_entry xA0;
	toc_entry xA1;
	toc_entry xA2;
	/* xb0 -> xb4 skip interval pointers */
	toc_entry xB0;
	toc_entry xB1;
	toc_entry xB2;
	toc_entry xB3;
	toc_entry xB4;
	/* s01 -> s40 skip interval descriptors */
	toc_entry s01;
	toc_entry s02;
	toc_entry s03;
	toc_entry s04;
	toc_entry s05;
	toc_entry s06;
	toc_entry s07;
	toc_entry s08;
	toc_entry s09;
	toc_entry s0A;
	toc_entry s0B;
	toc_entry s0C;
	toc_entry s0D;
	toc_entry s0E;
	toc_entry s0F;
	toc_entry s10;
	toc_entry s11;
	toc_entry s12;
	toc_entry s13;
	toc_entry s14;
	toc_entry s15;
	toc_entry s16;
	toc_entry s17;
	toc_entry s18;
	toc_entry s19;
	toc_entry s1A;
	toc_entry s1B;
	toc_entry s1C;
	toc_entry s1D;
	toc_entry s1E;
	toc_entry s1F;
	toc_entry s20;
	toc_entry s21;
	toc_entry s22;
	toc_entry s23;
	toc_entry s24;
	toc_entry s25;
	toc_entry s26;
	toc_entry s27;
	toc_entry s28;
	toc_entry s29;
	toc_entry s2A;
	toc_entry s2B;
	toc_entry s2C;
	toc_entry s2D;
	toc_entry s2E;
	toc_entry s2F;
	toc_entry s30;
	toc_entry s31;
	toc_entry s32;
	toc_entry s33;
	toc_entry s34;
	toc_entry s35;
	toc_entry s36;
	toc_entry s37;
	toc_entry s38;
	toc_entry s39;
	toc_entry s3A;
	toc_entry s3B;
	toc_entry s3C;
	toc_entry s3D;
	toc_entry s3E;
	toc_entry s3F;
	toc_entry s40;
	/* xC0 -> xC1 additional information */
	toc_entry xC0;
	toc_entry xC1;
} toc_session;
