/* $Id: scsi_gen_disk.c,v 1.85 2009-01-28 12:59:21 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define INCLUDE
#include "arch_scsi_gen_disk.c"
#undef INCLUDE

#include "scsi_gen_disk.h"

#define COMP "scsi_gen_disk"

struct cpssp {
	/* Ports */
	struct sig_boolean *sig_5V;
	struct sig_boolean *sig_12V;
	struct sig_scsi_bus *port_scsi_bus;

	/* Signals */

#define STATE
#define NAME		disk
#define	NAME_(x)	disk_ ## x
#define SNAME		"disk"
#include "arch_scsi_gen_disk.c"
#undef SNAME
#undef NAME_
#undef NAME
#undef STATE
};

static void
disk_phase_msg_out(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_msg_out(cpssp->port_scsi_bus, cpssp);
}

static void
disk_phase_msg_in(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_msg_in(cpssp->port_scsi_bus, cpssp);
}

static void
disk_phase_cmd(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_command(cpssp->port_scsi_bus, cpssp);
}

static void
disk_phase_data_in(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_data_in(cpssp->port_scsi_bus, cpssp);
}

static void
disk_phase_data_out(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_data_out(cpssp->port_scsi_bus, cpssp);
}

static void
disk_phase_status(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_status(cpssp->port_scsi_bus, cpssp);
}

static void
disk_phase_free(struct cpssp *cpssp)
{
	sig_scsi_bus_phase_free(cpssp->port_scsi_bus, cpssp);
}

static void
disk_want_recv(struct cpssp *cpssp, unsigned long count)
{
	sig_scsi_bus_want_recv(cpssp->port_scsi_bus, cpssp, count);
}

static void
disk_want_send(struct cpssp *cpssp, unsigned long count)
{
	sig_scsi_bus_want_send(cpssp->port_scsi_bus, cpssp, count);
}

#define BEHAVIOR
#define NAME		disk
#define	NAME_(x)	disk_ ## x
#define SNAME		"disk"
#include "arch_scsi_gen_disk.c"
#undef SNAME
#undef NAME_
#undef NAME
#undef BEHAVIOR

static void
scsi_gen_disk_power_set(void *_cpssp, unsigned int val)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

        disk_power_set(cpssp, val);
}

static int
scsi_gen_disk_phase_select(void *_cpssp, uint32_t id)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

        return disk_phase_select(cpssp, id);
}

static int
scsi_gen_disk_phase_reselect(void *_cpssp, uint32_t id)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

        return disk_phase_reselect(cpssp, id);
}

static void
scsi_gen_disk_phase_msg_out(void *_cpssp)
{
        /* Nothing to do... */
}

static void
scsi_gen_disk_phase_msg_in(void *_cpssp)
{
        /* Nothing to do... */
}

static void
scsi_gen_disk_phase_command(void *_cpssp)
{
        /* Nothing to do... */
}

static void
scsi_gen_disk_phase_data_out(void *_cpssp)
{
        /* Nothing to do... */
}

static void
scsi_gen_disk_phase_data_in(void *_cpssp)
{
        /* Nothing to do... */
}

static void
scsi_gen_disk_phase_status(void *_cpssp)
{
        /* Nothing to do... */
}


static void
scsi_gen_disk_phase_free(void *_cpssp)
{
        /* Nothing to do... */
}

static void
scsi_gen_disk_atn_set(void *_cpssp, unsigned int val)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

        return disk_atn_set(cpssp, val);
}

void
scsi_gen_disk_want_recv(
        void *_cpssp,
        unsigned long bufsize
)
{
	/* called always from the target ==> not relevant here! */
}

void
scsi_gen_disk_want_send(
        void *_cpssp,
        unsigned long bufsize
)
{
	/* called always from the target ==> not relevant here! */
}

static unsigned long
scsi_gen_disk_send(
        void *_cpssp,
        const uint8_t *buf,
        unsigned long bufsize
)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

        return disk_send(cpssp, buf, bufsize);
}

static unsigned long
scsi_gen_disk_recv(
        void *_cpssp,
        uint8_t *buf,
        unsigned long bufsize
)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

        return disk_recv(cpssp, buf, bufsize);
}

void
scsi_gen_disk_init(
        unsigned int nr,
        struct sig_power_device *port_power,
        struct sig_scsi_bus *port_scsi
)
{
        static const struct sig_boolean_funcs power_funcs = {
                .set = scsi_gen_disk_power_set,
        };
        static const struct sig_scsi_bus_funcs funcs = {
                .phase_select = scsi_gen_disk_phase_select,
                .phase_reselect = scsi_gen_disk_phase_reselect,
                .phase_msg_out = scsi_gen_disk_phase_msg_out,
                .phase_msg_in = scsi_gen_disk_phase_msg_in,
                .phase_command = scsi_gen_disk_phase_command,
                .phase_data_out = scsi_gen_disk_phase_data_out,
                .phase_data_in = scsi_gen_disk_phase_data_in,
                .phase_status = scsi_gen_disk_phase_status,
                .phase_free = scsi_gen_disk_phase_free,

                .atn_set = scsi_gen_disk_atn_set,

                .want_recv = scsi_gen_disk_want_recv,
                .want_send = scsi_gen_disk_want_send,

                .send = scsi_gen_disk_send,
                .recv = scsi_gen_disk_recv,
        };

        struct cpssp *cpssp;

        cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

        cpssp->sig_5V = port_power->power_5V;
        sig_boolean_connect_in(port_power->power_5V, cpssp, &power_funcs);
        cpssp->sig_12V = port_power->power_12V;

        cpssp->port_scsi_bus = port_scsi;
        sig_scsi_bus_connect(port_scsi, cpssp, &funcs);

	disk_init(cpssp);
}

void
scsi_gen_disk_create(
        unsigned int nr,
        const char *name,
        const char *scsi_id,
        const char *size
)
{
        struct cpssp *cpssp;
	int id;
	unsigned long size_mb;
        char path[1024];

        shm_create(COMP, nr, sizeof(*cpssp));
        cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

        /* Get Config */
        id = strtoul(scsi_id, NULL, 0);
        size_mb = strtoul(size, NULL, 0);

        /* check SCSI-ID */
        assert(0 <= id && id < 7);

        /* FIX ME: Overlow check! */
        sprintf(path, COMP "-%d.media", nr);

	disk_create(cpssp, path, id, size_mb);

        shm_unmap(cpssp, sizeof(*cpssp));
}

void
scsi_gen_disk_destroy(unsigned int nr)
{
        struct cpssp *cpssp;

        cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	disk_destroy(cpssp);

        shm_unmap(cpssp, sizeof(*cpssp));
        shm_destroy(COMP, nr);
}
