/* $Id: sig_fault.c,v 1.6 2009-01-27 17:06:41 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "sig_fault.h"

void
sig_fault_set(
	struct sig_fault *b,
	void *s,
	unsigned long long loc0,
	unsigned long long loc1,
	unsigned int val
)
{
	unsigned int nr;

	for (nr = 0; nr < b->member_count; nr++) {
		if (b->member[nr].s == s
		 || ! b->member[nr].f
		 || ! b->member[nr].f->set) {
			continue;
		}
		(*b->member[nr].f->set)(b->member[nr].s, loc0, loc1, val);
	}
}

void
sig_fault_connect(
	struct sig_fault *b,
	void *s,
	const struct sig_fault_funcs *f
)
{
	assert(b);
	assert(b->member_count < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->member_count].s = s;
	b->member[b->member_count].f = f;
	b->member_count++;
}

struct sig_fault *
sig_fault_init(const char *name, unsigned int nr)
{
	struct sig_fault *b;

	b = shm_map(name, nr, sizeof(*b), 0);

	b->member_count = 0;

	return b;
}

void
sig_fault_create(const char *name, unsigned int nr)
{
	shm_create(name, nr, sizeof(struct sig_fault));
}

void
sig_fault_destroy(const char *name, unsigned int nr)
{
	shm_destroy(name, nr);
}
