/* $Id: sig_integer.h,v 1.5 2009-01-27 17:44:20 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_INTEGER_H_INCLUDED
#define __SIG_INTEGER_H_INCLUDED

#include "sig_gen.h"

struct sig_integer_funcs {
	void (*set)(void *s, int val);
};

struct sig_integer {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_integer_funcs *f;
		int in;
	} in[4];
	unsigned int in_count;

	struct {
		void *s;
		int out;
	} out[1];
	unsigned int out_count;
};

extern void
sig_integer_set(struct sig_integer *b, void *s, int val);

extern void
sig_integer_connect_in(
	struct sig_integer *b,
	void *s,
	const struct sig_integer_funcs *f
);
extern void
sig_integer_connect_out(
	struct sig_integer *b,
	void *s,
	int val
);

extern struct sig_integer *
sig_integer_init(const char *name, unsigned int nr);

extern void
sig_integer_create(const char *name, unsigned int nr);
extern void
sig_integer_destroy(const char *name, unsigned int nr);

#endif /* __SIG_INTEGER_H_INCLUDED */
