/* $Id: sig_keyboard.c,v 1.5 2009-01-27 17:06:41 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "sig_keyboard.h"

int
sig_keyboard_key_press(
	struct sig_keyboard *b,
	void *s,
	unsigned int key
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned int);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->key_press;
		if (func
		 && func(b->member[nr].s, key) == 0) {
			return 0;
		}
	}
}

int
sig_keyboard_key_release(
	struct sig_keyboard *b,
	void *s,
	unsigned int key
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned int);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->key_release;
		if (func
		 && func(b->member[nr].s, key) == 0) {
			return 0;
		}
	}
}

int
sig_keyboard_led_on(
	struct sig_keyboard *b,
	void *s,
	unsigned int led
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned int);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->led_on;
		if (func
		 && func(b->member[nr].s, led) == 0) {
			return 0;
		}
	}
}

int
sig_keyboard_led_off(
	struct sig_keyboard *b,
	void *s,
	unsigned int led
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned int);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->led_off;
		if (func
		 && func(b->member[nr].s, led) == 0) {
			return 0;
		}
	}
}

void
sig_keyboard_connect(
	struct sig_keyboard *b,
	void *s,
	const struct sig_keyboard_funcs *f
)
{
	assert(b);
	assert(b->member_count < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->member_count].s = s;
	b->member[b->member_count].f = f;
	b->member_count++;
}

struct sig_keyboard *
sig_keyboard_init(const char *name, unsigned int nr)
{
	struct sig_keyboard *b;

	b = shm_map(name, nr, sizeof(*b), 0);

	b->member_count = 0;

	return b;
}

void
sig_keyboard_create(const char *name, unsigned int nr)
{
	shm_create(name, nr, sizeof(struct sig_keyboard));
}

void
sig_keyboard_destroy(const char *name, unsigned int nr)
{
	shm_destroy(name, nr);
}
