/*
 * $Id: conn_ps2.c,v 1.1 2009-05-07 10:36:34 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "conn_ps2.h"

#define COMP "conn_ps2"

struct cpssp {
	struct sig_boolean_merge *forward_power;
	struct sig_ps2_main_merge *forward_main;
};

void
conn_ps2_init(
	unsigned int nr,
	struct sig_ps2 *port_female,
	struct sig_boolean *port__plus_5V,
	struct sig_ps2_main *port_board
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward_main = sig_ps2_main_merge(port_female->main, port_board);
	cpssp->forward_power = sig_boolean_merge(port_female->p5V, port__plus_5V);
}

unsigned int
conn_ps2_create(void)
{
	static unsigned int nr = 0;

	shm_create(COMP, nr, sizeof(struct cpssp));

	return nr++;
}

void
conn_ps2_destroy(unsigned int nr)
{
	shm_destroy(COMP, nr);
}
