/*
 * $Id: conn_slot1.c,v 1.7 2009-01-28 12:59:19 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-shm.h"

#include "conn_slot1.h"

#define COMP	"conn_slot1"

struct cpssp {
	struct sig_boolean_merge *forward_power;
	struct sig_boolean_merge *forward_n_reset;
	struct sig_boolean_merge *forward_n_init;
	struct sig_host_bus_main_merge *forward_main;
	struct sig_boolean_or_merge *forward_lint0;
	struct sig_boolean_or_merge *forward_lint1;
	struct sig_boolean_merge *forward_smi;
	struct sig_boolean_merge *forward_a20;
	struct sig_boolean_or_merge *forward_n_ferr;
	struct sig_boolean_merge *forward_n_ignne;
	struct sig_icc_bus_merge *forward_icc;
};

	void
conn_slot1_init(
	unsigned int nr,

	struct sig_host_bus *port_cpu,

	struct sig_boolean *port_power,
	struct sig_boolean *port_n_reset,
	struct sig_boolean *port_n_init,
	struct sig_host_bus_main *port_main,
	struct sig_boolean_or *port_lint0,
	struct sig_boolean_or *port_lint1,
	struct sig_boolean *port_smi,
	struct sig_boolean *port_a20,
	struct sig_boolean_or *port_n_ferr,
	struct sig_boolean *port_n_ignne,
	struct sig_icc_bus *port_icc
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward_power = sig_boolean_merge(
			port_power, port_cpu->power);
	cpssp->forward_n_reset = sig_boolean_merge(
			port_n_reset, port_cpu->n_reset);
	cpssp->forward_n_init = sig_boolean_merge(
			port_n_init, port_cpu->n_init);
	cpssp->forward_main = sig_host_bus_main_merge(
			port_cpu->main, port_main);
	cpssp->forward_lint0 = sig_boolean_or_merge(
			port_lint0, port_cpu->lint0);
	cpssp->forward_lint1 = sig_boolean_or_merge(
			port_lint1, port_cpu->lint1);
	cpssp->forward_smi = sig_boolean_merge(
			port_smi, port_cpu->smi);
	cpssp->forward_a20 = sig_boolean_merge(
			port_a20, port_cpu->a20);
	cpssp->forward_n_ferr = sig_boolean_or_merge(
			port_cpu->n_ferr, port_n_ferr);
	cpssp->forward_n_ignne = sig_boolean_merge(
			port_n_ignne, port_cpu->n_ignne);
	cpssp->forward_icc = sig_icc_bus_merge(
			port_icc, port_cpu->icc);
}

unsigned int
conn_slot1_create(void)
{
	static unsigned int nr = 0;

	shm_create(COMP, nr, sizeof(struct cpssp));

	return nr++;
}

void
conn_slot1_destroy(unsigned int nr)
{
	shm_destroy(COMP, nr);
}
