/*
 * $Id: floppy_gen_floppydrive_gui.c,v 1.8 2009-03-14 06:29:01 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "floppy_gen_floppydrive_gui.h"

#ifdef HAVE_GTK
#include "floppy_gen_floppydrive_gui_gtk.h"
#endif

void
floppy_gen_floppydrive_gui_init(
	unsigned int nr,
	struct sig_power_device *port_power,
	struct sig_shugart_bus *port_shugart,
	struct sig_boolean *port_opt_busy_led,
	struct sig_string *port_change
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		floppy_gen_floppydrive_gui_gtk_init(
				nr,
				port_power,
				port_shugart,
				port_opt_busy_led,
				port_change);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
floppy_gen_floppydrive_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *model,
	const char *unit
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		floppy_gen_floppydrive_gui_gtk_create(
				page,
				nr,
				name,
				model,
				unit);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
floppy_gen_floppydrive_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		floppy_gen_floppydrive_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
