/*
 * $Id: ide_gen_cdrom_gui.c,v 1.7 2009-03-26 14:54:04 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "ide_gen_cdrom_gui.h"

#ifdef HAVE_GTK
#include "ide_gen_cdrom_gui_gtk.h"
#endif

void
ide_gen_cdrom_gui_init(
	unsigned int nr,
	struct sig_power_device *port_power,
	struct sig_ide_bus *port_ide,
	struct sig_magneto_optical *port_media,
	struct sig_string *port_change,
	struct sig_fault *fault_fault
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ide_gen_cdrom_gui_gtk_init(nr, port_power, port_ide,
				port_media, port_change, fault_fault);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
ide_gen_cdrom_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *unit_str
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ide_gen_cdrom_gui_gtk_create(page, nr, name, unit_str);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
ide_gen_cdrom_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ide_gen_cdrom_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
