/*
 * $Id: isa_gen_ne2000_rom.c,v 1.3 2009-03-16 20:06:37 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue-shm.h"

#include "isa_gen_ne2000_rom.h"

#define CHIP_(x) isa_gen_ne2000_rom_ ## x
#define CHIP "isa_gen_ne2000_rom"

struct cpssp {
	/* Config */
	uint8_t mac[6];

	/* Ports */
	unsigned int state_power;
	struct sig_cs *port_cs;

	/* State */
	uint8_t rom[32];
};

static int
CHIP_(readb)(void *_cpssp, uint8_t *valp, unsigned long addr)
{
	struct cpssp *cpssp = _cpssp;

	*valp = cpssp->rom[addr & 0x1f];

	return 0;
}

static void
CHIP_(power_set)(void *_cpssp, unsigned int val)
{
	/* FIXME */
}

void
CHIP_(init)(
	unsigned int nr,
	struct sig_boolean *port_power,
	struct sig_cs *port_cs,
	struct sig_isa_bus_main *port_bus
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = CHIP_(power_set),
	};
	static const struct sig_cs_funcs cs_funcs = {
		.readb = CHIP_(readb),
	};
	struct cpssp *cpssp;

	cpssp = shm_map(CHIP, nr, sizeof(*cpssp), 0);

	/* Call */
	cpssp->port_cs = port_cs;
	sig_cs_connect(port_cs, cpssp, &cs_funcs);

	/* Out */
	/* In */
	cpssp->state_power = 0;
	sig_boolean_connect_in(port_power, cpssp, &power_funcs);

}

unsigned int
CHIP_(create)(const char mac[6])
{
	static unsigned int nr = 0;
	static uint8_t mac_default[6] = { 0x00, 0x01, 0x02, 0x00, 0x00, 0x00 };
	struct cpssp *cpssp;
	unsigned int m[6];

	shm_create(CHIP, nr, sizeof(*cpssp));
	cpssp = shm_map(CHIP, nr, sizeof(*cpssp), 0);

	if (mac == NULL
	 || strcmp(mac, "00:00:00:00:00:00") == 0) {
		cpssp->mac[0] = mac_default[0];
		cpssp->mac[1] = mac_default[1];
		cpssp->mac[2] = mac_default[2];
		cpssp->mac[3] = mac_default[3];
		cpssp->mac[4] = mac_default[4];
		cpssp->mac[5] = mac_default[5];
		mac_default[5]++;

	} else {
		sscanf(mac, "%x:%x:%x:%x:%x:%x",
				&m[0], &m[1], &m[2], &m[3], &m[4], &m[5]);
		cpssp->mac[0] = m[0];
		cpssp->mac[1] = m[1];
		cpssp->mac[2] = m[2];
		cpssp->mac[3] = m[3];
		cpssp->mac[4] = m[4];
		cpssp->mac[5] = m[5];
	}

	cpssp->rom[0x00] = cpssp->rom[0x01] = cpssp->mac[0];
	cpssp->rom[0x02] = cpssp->rom[0x03] = cpssp->mac[1];
	cpssp->rom[0x04] = cpssp->rom[0x05] = cpssp->mac[2];
	cpssp->rom[0x06] = cpssp->rom[0x07] = cpssp->mac[3];
	cpssp->rom[0x08] = cpssp->rom[0x09] = cpssp->mac[4];
	cpssp->rom[0x0a] = cpssp->rom[0x0b] = cpssp->mac[5];
	cpssp->rom[0x0c] = cpssp->rom[0x0d] = 0; /* FIXME */
	cpssp->rom[0x0e] = cpssp->rom[0x0f] = 0; /* FIXME */
	cpssp->rom[0x10] = cpssp->rom[0x11] = 0; /* FIXME */
	cpssp->rom[0x12] = cpssp->rom[0x13] = 0; /* FIXME */
	cpssp->rom[0x14] = cpssp->rom[0x15] = 5; /* FIXME */
	cpssp->rom[0x16] = cpssp->rom[0x17] = 1; /* FIXME */
	cpssp->rom[0x18] = cpssp->rom[0x19] = 28; /* FIXME */
	cpssp->rom[0x1a] = cpssp->rom[0x1b] = 2; /* FIXME */
	cpssp->rom[0x1c] = cpssp->rom[0x1d] = 87; /* FIXME */
	cpssp->rom[0x1e] = cpssp->rom[0x1f] = 87; /* FIXME */

	shm_unmap(cpssp, sizeof(*cpssp));

	return nr++;
}

void
CHIP_(destroy)(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(CHIP, nr, sizeof(*cpssp), 0);

	/* FIXME */

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(CHIP, nr);
}
