/*
 * $Id: telephone_switch_gui.c,v 1.5 2009-03-14 06:29:02 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "telephone_switch_gui.h"

#ifdef HAVE_GTK
#include "telephone_switch_gui_gtk.h"
#endif

void
telephone_switch_gui_init(
	unsigned int nr,
	struct sig_boolean *port_switch,
	struct sig_telephone *port_phone0,
	struct sig_telephone *port_phone1,
	struct sig_telephone *port_phone2,
	struct sig_boolean *port_carrier0,
	struct sig_boolean *port_carrier1,
	struct sig_boolean *port_carrier2,
	struct sig_integer *port_connected0,
	struct sig_integer *port_connected1,
	struct sig_integer *port_connected2
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		telephone_switch_gui_gtk_init(
				nr,
				port_switch,
				port_phone0,
				port_phone1,
				port_phone2,
				port_carrier0,
				port_carrier1,
				port_carrier2,
				port_connected0,
				port_connected1,
				port_connected2
				);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
telephone_switch_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *num1,
	const char *num2,
	const char *num3
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		telephone_switch_gui_gtk_create(
				page,
				nr,
				name,
				num1,
				num2,
				num3
				);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
telephone_switch_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		telephone_switch_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
