/*
 * $Id: vt102_core_gui.c,v 1.5 2009-03-14 06:29:02 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "vt102_core_gui.h"

#ifdef HAVE_GTK
#include "vt102_core_gui_gtk.h"
#endif

void
vt102_core_gui_init(
	unsigned int nr,
	struct sig_boolean *port_mech_power_switch,
	struct sig_serial *port_serial,
	struct sig_integer *port_keyboard,
	struct sig_video *port_video
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		vt102_core_gui_gtk_init(
				nr,
				port_mech_power_switch,
				port_serial,
				port_keyboard,
				port_video
				);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
vt102_core_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name
)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		vt102_core_gui_gtk_create(page, nr, name);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
vt102_core_gui_destroy(unsigned int nr)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		vt102_core_gui_gtk_destroy(nr);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
