/*
 * $Id: system.h,v 1.52 2009-04-27 13:54:46 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SYSTEM_H_INCLUDED
#define __SYSTEM_H_INCLUDED

enum port_type {
	PORT_NONE = 0,

	PORT_CDDVD_DRIVE = 2,
	PORT_CDDVD_MEDIA,

	PORT_FLOPPY_DRIVE,
	PORT_FLOPPY_MEDIA,

	PORT_RJ45_FEMALE,
	PORT_RJ45_MALE,

	PORT_USB_FEMALE,
	PORT_USB_MALE,
};

extern int
system_node_create(const char *name);
extern int
system_node_destroy(unsigned int node_id);

extern int
system_page_create(const char *name);
extern int
system_page_destroy(unsigned int page_id);

extern int
system_sig_create(const char *type, const char *name);
extern void *
system_sig_get(unsigned int sig_id);
extern int
system_sig_unget(void *ptr);
extern int
system_sig_destroy(unsigned int sig);

extern int
system_sig_info(unsigned int sigid, char *type, char *name);

/** create a component.
 *  @param type component type.
 *  @param name path name of the component.
 *  @param node desired node id of the component.
 *  @param page desired page id of the component.
 *  @return component id or -1 on error.
 */
extern int
system_comp_create(
	const char *type,
	const char *name,
	unsigned int node,
	unsigned int page
);

/** set a generic of a component
 *  @param comp component id (as from system_comp_create)
 *  @param type VHDL type name.
 *  @param generic name of the generic
 *  @param value string representation of value.
 *  @return currently always 0
 */
extern int
system_comp_generic_set(unsigned int comp,
		const char *type, const char *name, const char *value);
extern int
system_comp_port_connect(unsigned int comp, const char *port, unsigned int sig);
extern int
system_comp_init(unsigned int comp);
extern int
system_comp_exit(unsigned int comp);
extern int
system_comp_destroy(unsigned int comp);

extern int
system_comp_info(unsigned int compid, char *type, char *name,
		unsigned int *nodep, unsigned int *pagep);
extern int
system_comp_generic_info(unsigned int compid, unsigned int genericid,
		char *type, char *generic, char *value);
extern int
system_comp_port_info(unsigned int compid, unsigned int portid,
		char *port, unsigned int *sigidp);

extern void
system_conn_merge(const char *comp0, const char *port0,
		const char *comp1, const char *port1);
extern void
system_conn_split(const char *comp0, const char *port0);

extern int
system_conn_list(enum port_type type, unsigned int nr,
		const char **compp, const char **portp);

extern void
system_comp_connect(unsigned int comp, const char *port, unsigned int sig);
extern void
system_comp_disconnect(unsigned int comp, const char *port);

/** lookup a component by path name
 *  @param name path name of component (same as name of system_comp_create)
 *  @return component id, or -1 if not found.
 */
extern int
system_comp_lookup(const char *name);

/** lookup a signal by path name
 *  @param name path name of signal (same as name of system_sig_create)
 *  @return signal id, or -1 if not found.
 */
extern int
system_sig_lookup(const char *name);

/* FIXME */
extern unsigned char floppydrive[4];

#endif /* __SYSTEM_H_INCLUDED */
