/*
 * $Id: sig_power.c,v 1.15 2009-05-21 16:38:08 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "sig_boolean.h"
#include "sig_power.h"

struct sig_power_board *
sig_power_board_create(const char *name)
{
	struct sig_power_board *c;
	char n[1000];

	c = malloc(sizeof(*c));
	assert(c);

	c->type = SIG_GEN_POWER_BOARD;

	sprintf(n, "%s-n_ps_on", name);
	c->n_ps_on = sig_std_logic_create(n);
	sprintf(n, "%s-+5Vsb", name);
	c->_plus_5Vsb = sig_boolean_create(n);
	sprintf(n, "%s-pwr_ok", name);
	c->pwr_ok = sig_boolean_create(n);
	sprintf(n, "%s-+3_3V", name);
	c->_plus_3_3V = sig_boolean_create(n);
	sprintf(n, "%s-+5V", name);
	c->_plus_5V = sig_boolean_create(n);
	sprintf(n, "%s--5V", name);
	c->_minus_5V = sig_boolean_create(n);
	sprintf(n, "%s-+12V", name);
	c->_plus_12V = sig_boolean_create(n);
	sprintf(n, "%s--12V", name);
	c->_minus_12V = sig_boolean_create(n);
	sprintf(n, "%s-gnd", name);
	c->gnd = sig_boolean_create(n);

	return c;
}

void
sig_power_board_destroy(struct sig_power_board *sig)
{
	assert(sig);
	/* assert(sig->type == ...); FIXME */

	sig_std_logic_destroy(sig->n_ps_on);
	sig_boolean_destroy(sig->_plus_5Vsb);
	sig_boolean_destroy(sig->pwr_ok);
	sig_boolean_destroy(sig->_plus_3_3V);
	sig_boolean_destroy(sig->_plus_5V);
	sig_boolean_destroy(sig->_minus_5V);
	sig_boolean_destroy(sig->_plus_12V);
	sig_boolean_destroy(sig->_minus_12V);
	sig_boolean_destroy(sig->gnd);

	free(sig);
}

struct sig_power_board_at *
sig_power_board_at_create(const char *name)
{
	struct sig_power_board_at *c;
	char n[1000];

	c = malloc(sizeof(*c));
	assert(c);

	sprintf(n, "%s-+5V", name);
	c->_plus_5V = sig_boolean_create(n);
	sprintf(n, "%s--5V", name);
	c->_minus_5V = sig_boolean_create(n);
	sprintf(n, "%s-+12V", name);
	c->_plus_12V = sig_boolean_create(n);
	sprintf(n, "%s--12V", name);
	c->_minus_12V = sig_boolean_create(n);
	sprintf(n, "%s-gnd", name);
	c->gnd = sig_boolean_create(n);

	return c;
}

void
sig_power_board_at_destroy(struct sig_power_board_at *sig)
{
	assert(sig);
	/* assert(sig->type == ...); FIXME */

	sig_boolean_destroy(sig->_plus_5V);
	sig_boolean_destroy(sig->_minus_5V);
	sig_boolean_destroy(sig->_plus_12V);
	sig_boolean_destroy(sig->_minus_12V);
	sig_boolean_destroy(sig->gnd);

	free(sig);
}

struct sig_power_device *
sig_power_device_create(const char *name)
{
	struct sig_power_device *c;
	char n[1000];

	c = malloc(sizeof(*c));
	assert(c);

	c->type = SIG_GEN_POWER_DEVICE;

	sprintf(n, "%s-power_5V", name);
	c->power_5V = sig_boolean_create(n);
	sprintf(n, "%s-power_12V", name);
	c->power_12V = sig_boolean_create(n);
	sprintf(n, "%s-gnd", name);
	c->gnd = sig_boolean_create(n);

	return c;
}

void
sig_power_device_destroy(struct sig_power_device *sig)
{
	assert(sig);
	/* assert(sig->type == ...); FIXME */

	sig_boolean_destroy(sig->power_5V);
	sig_boolean_destroy(sig->power_12V);
	sig_boolean_destroy(sig->gnd);

	free(sig);
}
