/*
 * $Id: sig_serial.c,v 1.13 2009-05-21 16:38:09 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "sig_serial.h"

void
sig_serial_send(
	struct sig_serial *b,
	void *s,
	uint8_t c
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		b->member[nr].f->recv(b->member[nr].s, c);
	}
}

void
sig_serial_connect(
	struct sig_serial *b,
	void *s,
	const struct sig_serial_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_SERIAL);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_serial *
sig_serial_create(const char *name)
{
	struct sig_serial *sig;

	sig = malloc(sizeof(*sig));
	assert(sig);

	sig->type = SIG_GEN_SERIAL;
	sig->nmembers = 0;

	return sig;
}

void
sig_serial_destroy(struct sig_serial *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_SERIAL);

	free(sig);
}
