/*
 * $Id: conn_vga.c,v 1.6 2009-06-03 11:34:06 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "conn_vga.h"

struct cpssp {
	struct sig_video_merge *forward_video;
	struct sig_i2c_bus_merge *forward_i2c_bus;
};

void *
conn_vga_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_vga *port_port_vga,
	struct sig_vga *port_vga
)
{
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_video = sig_video_merge(
			port_port_vga->video, port_vga->video);
	cpssp->forward_i2c_bus = sig_i2c_bus_merge(
			port_port_vga->ddc, port_vga->ddc);

	return cpssp;
}

void
conn_vga_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
