/*
 * $Id: cpu_intel_x86_64.c,v 1.15 2009-06-03 11:34:06 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "fixme.h"

#include "chip_intel_x86_64.h"

#include "cpu_intel_x86_64.h"

struct cpssp {
	void *chip;
};

void *
cpu_intel_x86_64_create(
	const char *name,
	struct sig_manage *port_manage,
        struct sig_host_bus *port_conn
)
{
        struct cpssp *cpssp;

        cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

        cpssp->chip = chip_intel_x86_64_create(name,
			port_manage,
			port_conn->power,
			port_conn->n_reset,
			port_conn->n_init,
			port_conn->lint0,
			port_conn->lint0,
			port_conn->smi,
			port_conn->n_ferr,
			port_conn->n_ignne,
			port_conn->a20,
#if CONFIG_CPU_APIC_SUPPORT
			port_conn->icc,
#endif
			port_conn->main);

	return cpssp;
}

void
cpu_intel_x86_64_destroy(void *_cpssp)
{
        struct cpssp *cpssp = _cpssp;

        chip_intel_x86_64_destroy(cpssp->chip);

        free(cpssp);
}
