/*
 * $Id: telephone_switch_gui_gtk.c,v 1.21 2009-06-03 11:34:11 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-switch.h"

#include "telephone_switch_gui_gtk.h"

#define COMP "telephone_switch"

struct cpssp {
	GtkWidget *gui_power;
	struct term_entries {
		GtkWidget *line_carrier;
		GtkWidget *line_connected;
		GtkWidget *peer;
	} term_entry[3];

	struct sig_boolean *port_switch;
};

/*
 * Simulator Callbacks
 */
static void
telephone_switch_switch_set(void *_cpssp, unsigned int val)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_switch_set(GUI_GTK_SWITCH(cpssp->gui_power),
			(gboolean) val);
	gui_gtk_flush();
}

static void
gui_carrier_set(void *data, unsigned int val)
{
        struct term_entries *entry = (struct term_entries *) data;
        GtkWidget *img = entry->line_carrier;

        if (val) {
                gtk_image_set_from_stock(GTK_IMAGE(img), GTK_STOCK_YES, GTK_ICON_SIZE_BUTTON);
        } else {
                gtk_image_set_from_stock(GTK_IMAGE(img), GTK_STOCK_NO, GTK_ICON_SIZE_BUTTON);
        }

        gui_gtk_flush();
}

static void
gui_connected_set(void *data, int val)
{
        struct term_entries *entry = (struct term_entries *) data;
        GtkWidget *img = entry->line_connected;
        GtkWidget *lbl = entry->peer;


        if (0 <= val) {
                char peernum[50];

                gtk_image_set_from_stock(GTK_IMAGE(img), GTK_STOCK_YES, GTK_ICON_SIZE_BUTTON);
                snprintf(peernum, sizeof(peernum), "%d", val);
                gtk_label_set_text(GTK_LABEL(lbl), peernum);
        } else {
                gtk_image_set_from_stock(GTK_IMAGE(img), GTK_STOCK_NO, GTK_ICON_SIZE_BUTTON);
                gtk_label_set_text(GTK_LABEL(lbl), "-");
        }

        gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
telephone_switch_switched_on_event(GtkWidget *w, gpointer _cpssp)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_switch, cpssp, 1);
}

static void
telephone_switch_switched_off_event(GtkWidget *w, gpointer _cpssp)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_switch, cpssp, 0);
}

void *
telephone_switch_gui_gtk_create(
	unsigned int page,
	const char *name,
	const char *num1,
	const char *num2,
	const char *num3,
	struct sig_manage *port_manage,
	struct sig_boolean *port_switch,
	struct sig_telephone *port_phone0,
	struct sig_telephone *port_phone1,
	struct sig_telephone *port_phone2,
	struct sig_boolean *port_carrier0,
	struct sig_boolean *port_carrier1,
	struct sig_boolean *port_carrier2,
	struct sig_integer *port_connected0,
	struct sig_integer *port_connected1,
	struct sig_integer *port_connected2
)
{
        static const struct sig_boolean_funcs switch_funcs = {
                .set = telephone_switch_switch_set,
        };
        static const struct sig_boolean_funcs caf = {
                .set = gui_carrier_set,
        };
        static const struct sig_integer_funcs cof = {
                .set = gui_connected_set,
        };
	struct cpssp *cpssp;
        GtkTable *container;
        GtkWidget *lbl_number;
        GtkWidget *lbl_carrier;
        GtkWidget *lbl_connected;
        GtkWidget *lbl_peer;
        GtkWidget *top_sep;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *hsep;
	unsigned int i;

	if (num1 == 0) num1 = "1";
	if (num2 == 0) num2 = "2";
	if (num3 == 0) num3 = "3";

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);

	/* Power Switch */
	cpssp->gui_power = gui_gtk_switch_new();
        g_signal_connect(G_OBJECT(cpssp->gui_power), "switched-on",
                        G_CALLBACK(telephone_switch_switched_on_event),
                        cpssp);
        g_signal_connect(G_OBJECT(cpssp->gui_power), "switched-off",
                        G_CALLBACK(telephone_switch_switched_off_event),
                        cpssp);
        gtk_widget_show(cpssp->gui_power);

	/* Telephone Switch */
        container = GTK_TABLE(gtk_table_new(3 + 2, 4, 0));

        lbl_number = gtk_label_new("Number");
        lbl_carrier = gtk_label_new("Carrier");
        lbl_connected = gtk_label_new("Connected");
        lbl_peer = gtk_label_new("Peer");
        top_sep = gtk_hseparator_new();

        gtk_table_attach_defaults(container, lbl_number, 0, 1, 0, 1);
        gtk_table_attach_defaults(container, lbl_carrier, 1, 2, 0, 1);
        gtk_table_attach_defaults(container, lbl_connected, 2, 3, 0, 1);
        gtk_table_attach_defaults(container, lbl_peer, 3, 4, 0, 1);
        gtk_table_attach_defaults(container, top_sep, 0, 4, 1, 2);

        gtk_table_set_col_spacings(container, 10);
        gtk_table_set_row_spacings(container, 5);

        for (i = 0; i < 3; i++) {
                char snum[50];
                GtkWidget *number_lbl;

                switch (i) {
                case 0: strcpy(snum, num1); break;
                case 1: strcpy(snum, num2); break;
                case 2: strcpy(snum, num3); break;
                default: assert(0);
                }

                number_lbl = gtk_label_new(snum);
                cpssp->term_entry[i].line_carrier =
                                gtk_image_new_from_stock(GTK_STOCK_NO,
						GTK_ICON_SIZE_BUTTON);
                cpssp->term_entry[i].line_connected =
                                gtk_image_new_from_stock(GTK_STOCK_NO,
						GTK_ICON_SIZE_BUTTON);
                cpssp->term_entry[i].peer = gtk_label_new("-");

                gtk_table_attach_defaults(container,
                        number_lbl, 0, 1, i + 2, i + 3);

                gtk_table_attach_defaults(container,
                        cpssp->term_entry[i].line_carrier, 1, 2, i + 2, i + 3);

                gtk_table_attach_defaults(container,
                        cpssp->term_entry[i].line_connected, 2, 3, i + 2, i + 3);

                gtk_table_attach_defaults(container,
                        cpssp->term_entry[i].peer, 3, 4, i + 2, i + 3);
        }
        gtk_widget_show_all(GTK_WIDGET(container));

	hsep = gtk_hseparator_new();
	gtk_widget_show(hsep);

	gtk_box_pack_start(GTK_BOX(hbox), cpssp->gui_power, FALSE, FALSE, 2);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
	gtk_box_pack_start(GTK_BOX(vbox), hsep, FALSE, FALSE, 2);
	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(container), FALSE, FALSE, 4);

        gui_gtk_comp_add(page, COMP, name, vbox, FALSE, FALSE, NULL);

	/* Out */
	cpssp->port_switch = port_switch;
	sig_boolean_connect_out(port_switch, cpssp, 0);

        /* In */
        sig_boolean_connect_in(port_switch, cpssp, &switch_funcs);

        sig_boolean_connect_in(port_carrier0, &cpssp->term_entry[0], &caf);
        sig_boolean_connect_in(port_carrier1, &cpssp->term_entry[1], &caf);
        sig_boolean_connect_in(port_carrier2, &cpssp->term_entry[2], &caf);
        sig_integer_connect_in(port_connected0, &cpssp->term_entry[0], &cof);
        sig_integer_connect_in(port_connected1, &cpssp->term_entry[1], &cof);
        sig_integer_connect_in(port_connected2, &cpssp->term_entry[2], &cof);

	return cpssp;
}

void
telephone_switch_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
