/*
 * $Id: vt102_core_gui_gtk.c,v 1.16 2009-06-03 11:34:11 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-switch.h"

#include "vt102_core_gui_gtk.h"

#define COMP "vt102_core"

struct cpssp {
	GtkWidget *widget;

	struct sig_boolean *port_mech_power_switch;
};

/*
 * Simulator Callbacks
 */
static void
vt102_core_mech_power_switch_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_switch_set(GUI_GTK_SWITCH(cpssp->widget),
			(gboolean) val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
vt102_core_mech_power_switched_on_event(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_power_switch, cpssp, 1);
}

static void
vt102_core_mech_power_switched_off_event(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_power_switch, cpssp, 0);
}

void *
vt102_core_gui_gtk_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_mech_power_switch,
	struct sig_serial *port_serial,
	struct sig_integer *port_keyboard,
	struct sig_video *port_video
)
{
	static const struct sig_boolean_funcs mech_power_switch_funcs = {
		.set = vt102_core_mech_power_switch_set,
	};
	struct cpssp *cpssp;
	GtkWidget *vbox;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	vbox = gtk_vbox_new(FALSE, 1);

	cpssp->widget = gui_gtk_switch_new();
	g_signal_connect(G_OBJECT(cpssp->widget), "switched-on",
			G_CALLBACK(vt102_core_mech_power_switched_on_event),
			cpssp);
	g_signal_connect(G_OBJECT(cpssp->widget), "switched-off",
			G_CALLBACK(vt102_core_mech_power_switched_off_event),
			cpssp);
	gtk_widget_show(cpssp->widget);
	gtk_box_pack_end(GTK_BOX(vbox), cpssp->widget, FALSE, FALSE, 1);

	gtk_widget_show(vbox);
	gui_gtk_comp_add(page, COMP, name, vbox, FALSE, FALSE, NULL);

	/* Out */
	cpssp->port_mech_power_switch = port_mech_power_switch;
	sig_boolean_connect_out(port_mech_power_switch, cpssp, 0);

	/* In */
	sig_boolean_connect_in(port_mech_power_switch, cpssp,
			&mech_power_switch_funcs);

	return cpssp;
}

void
vt102_core_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
