/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE

#include "sig_std_logic.h"

#endif /* INCLUDE */

#ifdef STATE

struct {
	unsigned int state_cs;
	unsigned int state_mosi;
	unsigned int state_sck;

	unsigned int state;

	uint8_t shift;
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(mosi_in_set)(struct cpssp *cpssp, unsigned int val)
{
	switch (val) {
	case SIG_STD_LOGIC_L:
	case SIG_STD_LOGIC_0:
		val = 0;
		break;
	case SIG_STD_LOGIC_H:
	case SIG_STD_LOGIC_1:
		val = 1;
		break;
	default:
		val = 1;
		break;
	}

	cpssp->NAME.state_mosi = val;
}

static void
NAME_(cs_in_set)(struct cpssp *cpssp, unsigned int val)
{
	switch (val) {
	case SIG_STD_LOGIC_L:
	case SIG_STD_LOGIC_0:
		val = 0;
		break;
	case SIG_STD_LOGIC_H:
	case SIG_STD_LOGIC_1:
		val = 1;
		break;
	default:
		val = 1;
		break;
	}

	if (val == cpssp->NAME.state_cs) {
		return;
	}

	cpssp->NAME.state_cs = val;

	if (val == 0) {
		cpssp->NAME.state = 0;

		cpssp->NAME.shift = NAME_(read)(cpssp);
	}
}

static void
NAME_(sck_in_set)(struct cpssp *cpssp, unsigned int val)
{
	switch (val) {
	case SIG_STD_LOGIC_L:
	case SIG_STD_LOGIC_0:
		val = 0;
		break;
	case SIG_STD_LOGIC_H:
	case SIG_STD_LOGIC_1:
		val = 1;
		break;
	default:
		val = 1;
		break;
	}

	if (val == cpssp->NAME.state_sck) {
		return;
	}

	cpssp->NAME.state_sck = val;

	if (cpssp->NAME.state_cs == 0) {
		unsigned int bit;

		if (val == 0) {
			bit = (cpssp->NAME.shift >> 7) & 1;
			cpssp->NAME.shift <<= 1;
			NAME_(miso_out_set)(cpssp,
					bit ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
		} else {
			bit = cpssp->NAME.state_mosi;
			cpssp->NAME.shift |= bit;
		}

		cpssp->NAME.state++;

		if (cpssp->NAME.state == 16) {
			cpssp->NAME.state = 0;
			NAME_(write)(cpssp, cpssp->NAME.shift);
			cpssp->NAME.shift = NAME_(read)(cpssp);
		}
	}
}

static void
NAME_(create)(struct cpssp *cpssp)
{
	cpssp->NAME.state_cs = 1;
	cpssp->NAME.state_mosi = 1;
	cpssp->NAME.state_sck = 1;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */
