/*
 * Derived from QEMU sources.
 * Modified for FAUmachine by Volkmar Sieh.
 *
 *  Copyright (c) 2007-2016 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

#ifndef __CPU_FPU_FAST_H_INCLUDED
#define __CPU_FPU_FAST_H_INCLUDED

static inline void
fpush(struct cpssp *cpssp)
{
	cpssp->fpstt = (cpssp->fpstt - 1) & 7;
	cpssp->fptags[cpssp->fpstt] = 0; /* validate stack entry */
}

static inline void
fpop(struct cpssp *cpssp)
{
	cpssp->fptags[cpssp->fpstt] = 1; /* invvalidate stack entry */
	cpssp->fpstt = (cpssp->fpstt + 1) & 7;
}

extern void
CHIP_(helper_fldt_ST0_A0)(struct cpssp *cpssp, target_ulong a0);
extern void
CHIP_(helper_fstt_ST0_A0)(struct cpssp *cpssp, target_ulong a0);
extern void
CHIP_(fpu_raise_ferr)(struct cpssp *cpssp);
extern void
CHIP_(fpu_check_ferr)(struct cpssp *cpssp);
extern float80
CHIP_(helper_fdiv)(struct cpssp *cpssp, float80 a, float80 b);
extern void
CHIP_(helper_fbld_ST0_A0)(struct cpssp *cpssp, target_ulong a0);
extern void
CHIP_(helper_fbst_ST0_A0)(struct cpssp *cpssp, target_ulong a0);
extern void
CHIP_(helper_f2xm1)(struct cpssp *cpssp);
extern void
CHIP_(helper_fyl2x)(struct cpssp *cpssp);
extern void
CHIP_(helper_fptan)(struct cpssp *cpssp);
extern void
CHIP_(helper_fpatan)(struct cpssp *cpssp);
extern void
CHIP_(helper_fxtract)(struct cpssp *cpssp);
extern void
CHIP_(helper_fprem1)(struct cpssp *cpssp);
extern void
CHIP_(helper_fprem)(struct cpssp *cpssp);
extern void
CHIP_(helper_fyl2xp1)(struct cpssp *cpssp);
extern void
CHIP_(helper_fsqrt)(struct cpssp *cpssp);
extern void
CHIP_(helper_fsincos)(struct cpssp *cpssp);
extern void
CHIP_(helper_frndint)(struct cpssp *cpssp);
extern void
CHIP_(helper_fscale)(struct cpssp *cpssp);
extern void
CHIP_(helper_fsin)(struct cpssp *cpssp);
extern void
CHIP_(helper_fcos)(struct cpssp *cpssp);
extern void
CHIP_(helper_fxam_ST0)(struct cpssp *cpssp);
extern void
CHIP_(helper_fstenv)(struct cpssp *cpssp, target_ulong ptr, int data32);
extern void
CHIP_(helper_fldenv)(struct cpssp *cpssp, target_ulong ptr, int data32);
extern void
CHIP_(helper_fsave)(struct cpssp *cpssp, target_ulong ptr, int data32);
extern void
CHIP_(helper_frstor)(struct cpssp *cpssp, target_ulong ptr, int data32);
extern void
CHIP_(helper_fxsave)(struct cpssp *cpssp, target_ulong ptr, int data64);
extern void
CHIP_(helper_fxrstor)(struct cpssp *cpssp, target_ulong ptr, int data64);

extern void
CHIP_(get_fp80)(uint64_t *pmant, uint16_t *pexp, float80 f);
extern float80
CHIP_(set_fp80)(uint64_t mant, uint16_t upper);

extern float
CHIP_(approx_rsqrt)(float a);
extern float
CHIP_(approx_rcp)(float a);

extern void
CHIP_(update_fp_status)(struct cpssp *cpssp);

#endif /* __CPU_FPU_FAST_H_INCLUDED */
