/*
 * Copyright (C) 2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue.h"
#include "system.h"

#include "chip_intel_82555.h"

#define CHIP_(x) chip_intel_82555_ ## x

struct cpssp {
	struct sig_boolean *port_busy;
	unsigned int state_power;
	struct sig_mdi *port_mdi;
	struct sig_eth *port_eth;

#define STATE
#define NAME		phy
#define NAME_(x)	phy_ ## x
#define SNAME		"phy"
#include "arch_intel_82555.c"
#undef SNAME
#undef NAME_
#undef NAME
#undef STATE
};

static void
phy_recv_from_phy(struct cpssp *cpssp, const void *buf, unsigned int buflen)
{
	sig_mdi_send(cpssp->port_mdi, cpssp, buf, buflen);
}

#define BEHAVIOR
#define NAME		phy
#define NAME_(x)	phy_ ## x
#define SNAME		"phy"
#include "arch_intel_82555.c"
#undef SNAME
#undef NAME_
#undef NAME
#undef BEHAVIOR

static void
CHIP_(read)(void *_cpssp, unsigned int reg, uint16_t *valp)
{
	struct cpssp *cpssp = _cpssp;

	phy_reg_read(cpssp, reg, valp);
}

static void
CHIP_(write)(void *_cpssp, unsigned int reg, uint16_t val)
{
	struct cpssp *cpssp = _cpssp;

	phy_reg_write(cpssp, reg, val);
}

static void
CHIP_(recv_from_mac)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = _cpssp;

	phy_recv_from_controller(cpssp, buf, buflen);
}

static void
CHIP_(recv_from_eth)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = _cpssp;

	phy_recv_from_net(cpssp, buf, buflen);
}

static void
CHIP_(power_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_power = val;

	if (val) {
		phy_reset(cpssp);
	}
}

/* Reset? FIXME */

void *
CHIP_(create)(
	const char *name,
	struct sig_manage *manage,
	struct sig_std_logic *port_power,
	struct sig_mdi *port_mdi,
	struct sig_eth *port_eth,
	struct sig_boolean *port_busy
)
{
	static const struct sig_std_logic_funcs power_funcs = {
		.boolean_or_set = CHIP_(power_set),
	};
	static const struct sig_mdi_funcs mdi_funcs = {
		.read = CHIP_(read),
		.write = CHIP_(write),
		.recv = CHIP_(recv_from_mac),
	};
	static const struct sig_eth_funcs eth_funcs = {
		.recv = CHIP_(recv_from_eth),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	phy_create(cpssp);

	/* Call */
	cpssp->port_mdi = port_mdi;
	sig_mdi_connect(port_mdi, cpssp, &mdi_funcs);

	cpssp->port_eth = port_eth;
	sig_eth_connect(port_eth, cpssp, &eth_funcs);

	/* Out */
	cpssp->port_busy = port_busy;
	sig_boolean_connect_out(port_busy, cpssp, 0);

	/* In */
	cpssp->state_power = 0;
	sig_std_logic_connect_in(port_power, cpssp, &power_funcs);

	return cpssp;
}

void
CHIP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	phy_destroy(cpssp);

	shm_free(cpssp);
}

void
CHIP_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
CHIP_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
