/*
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "ferranti_abtaster_gui.h"
#ifdef HAVE_GTK
#include "ferranti_abtaster_gui_gtk.h"
#endif

#define COMP_(x) ferranti_abtaster_gui_ ## x

void *
COMP_(create)(
	unsigned int page,
	const char *name,
	struct sig_manage *manage,
	struct sig_boolean *port_power,
	struct sig_boolean *port_start,
	struct sig_boolean *port_bit0,
	struct sig_boolean *port_bit1,
	struct sig_boolean *port_bit2,
	struct sig_boolean *port_bit3,
	struct sig_boolean *port_bit4,
	struct sig_boolean *port_ready,
	struct sig_magneto_optical *port_media,
	struct sig_string *port_change,
	struct sig_boolean *port_hole0,
	struct sig_boolean *port_hole1,
	struct sig_boolean *port_hole2,
	struct sig_boolean *port_hole3,
	struct sig_boolean *port_hole4,
	struct sig_boolean *port_hole5
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return COMP_(gtk_create)(page, name, manage,
				port_power,
				port_start,
				port_bit0, port_bit1, port_bit2,
				port_bit3, port_bit4,
				port_ready,
				port_media, port_change,
				port_hole0, port_hole1, port_hole2,
				port_hole3, port_hole4, port_hole5);
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
COMP_(destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gtk_destroy)(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gtk_suspend)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gtk_resume)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
