/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "media_gen_floppy_gui.h"

#ifdef HAVE_GTK
#include "media_gen_floppy_gui_gtk.h"
#endif

#define COMP_(x) media_gen_floppy_ ## x

struct cpssp {
	struct sig_floppy *port_connect;
};

void *
COMP_(gui_create)(
	unsigned int page,
	const char *name,
	const char *size,
	const char *image,
	struct sig_manage *manage,
	struct sig_floppy *port_connect
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return COMP_(gui_gtk_create)(page, name,
				size, image, manage, port_connect);
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
COMP_(gui_destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_destroy)(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_suspend)(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_suspend)(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_resume)(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_resume)(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
