/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "scsi_gen_cdrom_gui.h"

#ifdef HAVE_GTK
#include "scsi_gen_cdrom_gui_gtk.h"
#endif

void *
scsi_gen_cdrom_gui_create(
	unsigned int page,
	const char *name,
	const char *scsi_id_str,
	struct sig_manage *port_manage,
	struct sig_molex_ide_power_conn *port_power,
	struct sig_scsi_bus *port_scsi,
	struct sig_magneto_optical *port_media,
	struct sig_string *port_change
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return scsi_gen_cdrom_gui_gtk_create(page, name,
				scsi_id_str,
				port_manage,
				port_power, port_scsi,
				port_media, port_change);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
scsi_gen_cdrom_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		scsi_gen_cdrom_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
scsi_gen_cdrom_gui_suspend(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		scsi_gen_cdrom_gui_gtk_suspend(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
scsi_gen_cdrom_gui_resume(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		scsi_gen_cdrom_gui_gtk_resume(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
