/*
 *  Copyright (C) 2008-2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sun.h"

#define COMP_(x)	sun_ ## x

struct cpssp {
	struct sig_opt_rgb *port_beam;
};

static void
COMP_(adj_set)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;
	uint8_t v;

	v = 255 * val / 100;

	sig_opt_rgb_pixel_set(cpssp->port_beam, cpssp, 0, 0, v, v, v);
}

void *
COMP_(create)(
	const char *name,
        struct sig_manage *port_manage,
	struct sig_integer *port_adj,
	struct sig_opt_rgb *port_beam
)
{
	static const struct sig_integer_funcs adj_funcs = {
		.set = COMP_(adj_set),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* Out */
	cpssp->port_beam = port_beam;

	/* In */
	sig_integer_connect_in(port_adj, cpssp, &adj_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
