/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define INP_0 1
#define INP_1 2
#define INP_2 3
#define INP_3 4

#define OUTP_0 5
#define OUTP_1 6
#define OUTP_2 7
#define OUTP_3 8


#ifdef STATE

#ifdef INP_0
#define IN_N 1
#endif

#ifdef INP_1
#undef IN_N
#define IN_N 2
#endif

#ifdef INP_2
#undef IN_N
#define IN_N 3
#endif

#ifdef INP_3
#undef IN_N
#define IN_N 4
#endif

#include "zuse_generic.c"

#endif /*STATE*/


#ifdef BEHAVIOUR

/* beautiful helper macros to create the function names*/
#define PASTER(x,y,z)	    x ## _ ## y ## _ ## z
#define EVALUATOR(x,y,z)    PASTER(x,y,z)

/* macros to concat function names */
#ifdef INP_0
#define NAME_IN_PORT_0_(z)  EVALUATOR(NAME, INP_0, z)
#endif

#ifdef INP_1
#define NAME_IN_PORT_1_(z)  EVALUATOR(NAME, INP_1, z)
#endif

#ifdef INP_2
#define NAME_IN_PORT_2_(z)  EVALUATOR(NAME, INP_2, z)
#endif

#ifdef INP_3
#define NAME_IN_PORT_3_(z)  EVALUATOR(NAME, INP_3, z)
#endif

#ifdef INP_4
#define NAME_IN_PORT_4_(z)  EVALUATOR(NAME, INP_4, z)
#endif

#ifdef OUTP_0
#define NAME_OUT_PORT_0_(z) EVALUATOR(NAME, OUTP_0, z)
#endif

#ifdef OUTP_1
#define NAME_OUT_PORT_1_(z) EVALUATOR(NAME, OUTP_1, z)
#endif

#ifdef OUTP_2
#define NAME_OUT_PORT_2_(z) EVALUATOR(NAME, OUTP_2, z)
#endif

#ifdef OUTP_3
#define NAME_OUT_PORT_3_(z) EVALUATOR(NAME, OUTP_3, z)
#endif

/* Debug makros */
#if DEBUG

#ifndef STR
#define STR(x)   #x
#endif /* STR */

#ifndef SHOW_DEFINE
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* SHOW_DEFINE */

#endif /* DEBUG */

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

static void
NAME_(solve)(struct cpssp *cpssp) {
    unsigned int res = SIG_STD_LOGIC_Z;

#ifdef INP_0
    res = res && 2000 < SIG_mV(cpssp->NAME.states[0]);
#endif
#ifdef INP_1
    res = res && 2000 < SIG_mV(cpssp->NAME.states[1]);
#endif
#ifdef INP_2
    res = res && 2000 < SIG_mV(cpssp->NAME.states[2]);
#endif
#ifdef INP_3
    res = res && 2000 < SIG_mV(cpssp->NAME.states[3]);
#endif
#ifdef INP_4
    res = res && 2000 < SIG_mV(cpssp->NAME.states[4]);
#endif

#if DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " sets to JUST A DUMMY\n");
#endif /* DEBUG */

#ifdef OUTP_0
    NAME_OUT_PORT_0_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
#endif
#ifdef OUTP_1
    NAME_OUT_PORT_1_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
#endif
#ifdef OUTP_2
    NAME_OUT_PORT_2_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
#endif
#ifdef OUTP_3
    NAME_OUT_PORT_3_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
#endif
}

#include "zuse_generic.c"

static void
NAME_(create)(struct cpssp *cpssp)
{
#ifdef INP_0
    NAME_IN_PORT_0_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_1
    NAME_IN_PORT_1_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_2
    NAME_IN_PORT_2_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_3
    NAME_IN_PORT_3_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_4
    NAME_IN_PORT_4_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
}

#ifdef INP_0
#undef NAME_IN_PORT_0_
#undef INP_0
#endif

#ifdef INP_1
#undef NAME_IN_PORT_1_
#undef INP_1
#endif

#ifdef INP_2
#undef NAME_IN_PORT_2_
#undef INP_2
#endif

#ifdef INP_3
#undef NAME_IN_PORT_3_
#undef INP_3
#endif

#ifdef INP_4
#undef NAME_IN_PORT_4_
#undef INP_4
#endif

#ifdef OUTP_0
#undef NAME_OUT_PORT_0_
#undef OUTP_0
#endif

#ifdef OUTP_1
#undef NAME_OUT_PORT_1_
#undef OUTP_1
#endif

#ifdef OUTP_2
#undef NAME_OUT_PORT_2_
#undef OUTP_2
#endif

#ifdef OUTP_3
#undef NAME_OUT_PORT_3_
#undef OUTP_3
#endif

#undef PASTER
#undef EVALUATOR

#endif /*BEHAVIOUR*/


#undef INP_0
#undef INP_1
#undef INP_2
#undef INP_3

#undef OUTP_0
#undef OUTP_1
#undef OUTP_2
#undef OUTP_3
