#!/bin/sh
#
# Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.
#

set -e

FAUM_ROOT=/home.shared/faui31i/potyra/work/FAUmachine
BINPATTERNM=$FAUM_ROOT/src/lib/pattern-matcher/test-patternm

# check for smart messages in screenshot $1
# return 0 if found, 1 if not found, 2 on error
match_pattern() {
	if [ ! -e $1 ]; then
		return 2;
	fi

	MATCH=$($BINPATTERNM --asc 'FAILED SMART' $1 2>&1 | grep 'is visible')

	if [ -z "$MATCH" ]; then
		return 1
	fi
	return 0
}

# FIXME 

# $1: directory of single run
# updated globals: 
evaluate_single_run() {
	LOG=$1/experiment.log

	RUNS=$(grep -e '[0-9]\{8\}-[0-9]\{6\}' $LOG \
		| cut -f 1 -d' ' \
		| sort \
		| uniq)

	for RUN in $RUNS; do
		FAULT=$(dirname $LOG)/$RUN.faults

		# is golden run?
		if [ ! -z "$(grep Golden $FAULT)" ]; then
			# did the golden run succeed? if not, skip remaining 
			# tests since these might not be meaningful.
			if [ -z "$(grep Success $FAULT)" ]; then
				echo "Golden run of $RUN on $HOST failed, "\
					"skipping"
				break
			fi
		else 
			#match for: FAILED SMART
			#1: smart sent mail during kernel compilation
			#2: smart spew errors during kernel compilation
			#3: smart sent mail during badblocks
			#4: smart spew errors after badblocks
			
			# deduced:
			# 1: all ok
			# (!1, 2): smart didn't send mail
			# (!1, !2, 3, 4): bad blocks not touched during compile
			# (!1, !2, !3, 4): smart didn't send mail in time
			# (!1, 2, !3, 4): smart didn't send mail at all(!)
			# FIXME anything else?

			SCREEN1=$(dirname $LOG)/$RUN.screenshot-001.png
			SCREEN2=$(dirname $LOG)/$RUN.screenshot-002.png
			SCREEN3=$(dirname $LOG)/$RUN.screenshot-003.png
			SCREEN4=$(dirname $LOG)/$RUN.screenshot-004.png
			set +e
			match_pattern $SCREEN1
			RES1=$?
			match_pattern $SCREEN2
			RES2=$?
			match_pattern $SCREEN3
			RES3=$?
			match_pattern $SCREEN4
			RES4=$?
			set -e

			echo "$FAULT=$RES1:$RES2:$RES3:$RES4"	
		fi
	done
}

get_run_directory() {
	HOST=$(echo $LIST | cut -d. -f3)
	T1=/home.shared/faui$HOST
	T2=$T1/potyra/work/FAUmachine/
	EXPDIR=$T2/src/experiments/test-fi-smart-step2
}

for LIST in tests.list.*; do
	get_run_directory

	RUN=$(echo $LIST | sed -e 's/tests.list.[0-9][0-1][a-z]//' \
			       -e 's/^.//' )
	
	if [ -z "$RUN" ]; then
		# single instance
		RUNDIR=$EXPDIR
	else
		# multiple instances add run suffix
		RUNDIR=$EXPDIR/run-$RUN
	fi
	evaluate_single_run $RUNDIR
done
