/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 *
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * Similar to
 * u-boot (Version 2009-11),
 *	drivers/mtd/spi/stmicro.c
 *	drivers/mtd/spi/spi_flash.c
 */

#include <stddef.h>

#include "assert.h"

#include "spi.h"
#include "stmicro.h"

#define CMD_M25PXX_FAST_READ	0x0b	/* Read Data Bytes at Higher Speed */

int
stmicro_read_fast(unsigned int offset, unsigned int len, void *buf)
{
	unsigned char cmd[5];

	cmd[0] = CMD_M25PXX_FAST_READ;
	cmd[1] = (offset >> 16) & 0xff;
	cmd[2] = (offset >> 8) & 0xff;
	cmd[3] = (offset >> 0) & 0xff;
	cmd[4] = 0;

	/* Claim bus. */
	spi_claim_bus();

	/* Send command. */
	spi_xfer(sizeof(cmd) * 8, cmd, NULL, SPI_XFER_BEGIN);

	/* Receive data. */
	spi_xfer(len * 8, NULL, buf, SPI_XFER_END);

	/* Release bus. */
	spi_release_bus();

	return 0;
}
