/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue.h"

#include "sig_eth.h"

void
sig_eth_send(
	struct sig_eth *b,
	void *s,
	const void *buf,
	unsigned int buflen
)
{
	unsigned int nr;

	for (nr = 0; nr < b->nmembers; nr++) {
		if (b->member[nr].s == s) {
			continue;
		}
		(*b->member[nr].f->recv)(b->member[nr].s, buf, buflen);
	}
}

void
sig_eth_connect(struct sig_eth *b, void *s, const struct sig_eth_funcs *f)
{
	assert(b);
	assert(b->type == SIG_GEN_ETH);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

static void
sig_eth_s0_recv(void *_f, const void *buf, unsigned int buflen)
{
	struct sig_eth_merge *f = _f;

	sig_eth_send(f->s1, f, buf, buflen);
}

static void
sig_eth_s1_recv(void *_f, const void *buf, unsigned int buflen)
{
	struct sig_eth_merge *f = _f;

	sig_eth_send(f->s0, f, buf, buflen);
}

struct sig_eth_merge *
sig_eth_merge(struct sig_eth *s0, struct sig_eth *s1)
{
	static struct sig_eth_funcs s0_funcs = {
		.recv = sig_eth_s0_recv,
	};
	static struct sig_eth_funcs s1_funcs = {
		.recv = sig_eth_s1_recv,
	};
	struct sig_eth_merge *m;

	m = shm_alloc(sizeof(*m));
	assert(m);

	/* Out */
	m->s0 = s0;
	m->s1 = s1;

	/* In */
	sig_eth_connect(s0, m, &s0_funcs);
	sig_eth_connect(s1, m, &s1_funcs);

	return m;
}

void
sig_eth_split(struct sig_eth_merge *m)
{
	fixme();
}

struct sig_eth *
sig_eth_create(const char *name)
{
	struct sig_eth *b;

	b = shm_alloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_ETH;
	b->nmembers = 0;

	return b;
}

void
sig_eth_destroy(struct sig_eth *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_ETH);

	shm_free(sig);
}

void
sig_eth_suspend(struct sig_eth *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
}

void
sig_eth_resume(struct sig_eth *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
}
