/*
 * fbgetty 
 * Copyright (C) 1999 2000 2001 Yann Droneaud <ydroneaud@meuh.eu.org>. 
 *
 * fbgetty is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * fbgetty is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#ifndef _FBGETTY_ERRORS_H_
#define _FBGETTY_ERRORS_H_

/* do some clean up before exiting, in case or error */
void fgcleanup(void);
void fgexit(int exitcode);

/* add a log printing function */
void fgmessage(int level, const char *fmt, ...);

void fatal_error (const char *fmt, ... );
void error (const char *fmt, ... );
void message (const char *fmt, ... );

#ifdef FBGETTY_DEBUG
#define debug(fmt,args...) message("[DEBUG] %s:%i:%s :" fmt, __FILE__, __LINE__, __ERROR_FUNCTION_NAME__ ,##args) 
#else
#define debug(fmt,args...)
#endif

/* __PRETTY_FUNCTION__ is a GCC only macro
   __func__ is a C standard macro from C99 norm */
#undef __ERROR_FUNCTION_NAME__
#ifdef __GNUC__
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 4)
#  define __ERROR_FUNCTION_NAME__   (__PRETTY_FUNCTION__)
# endif
#else
# if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#  define __ERROR_FUNCTION_NAME__   (__func__)
# endif
#endif

#ifndef __ERROR_FUNCTION_NAME__
#define __ERROR_FUNCTION_NAME__ ("<<unknown>>")
#endif

#endif /* _FBGETTY_ERRORS_H_ */

