/*
 * fbgetty 
 * Copyright (C) 2001 Yann Droneaud <ydroneaud@meuh.eu.org>. 
 *
 * fbgetty is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * fbgetty is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#ifndef _FBGETTY_SYSINFOS_H_
#define _FBGETTY_SYSINFOS_H_

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
# include <time.h>
#endif

#include <sys/utsname.h>

#define SYSINFOS_HOSTNAME_LEN 4096
#define SYSINFOS_FQDN_LEN SYSINFOS_HOSTNAME_LEN

typedef struct sysinfos
{
  /* some information about this host */
  struct utsname uts;

  /* the hostname */ 
  char hostname[SYSINFOS_HOSTNAME_LEN + 1];

  /* the fqdn */
  char fqdn[SYSINFOS_FQDN_LEN + 1];

  /* the broken down time */
  struct tm *broken_time;

  /* number of users */
  int users;

} sysinfos_t;

/* convert, format a broken down time structure to a string */
void
printf_time(FILE *out, const char *fmt, sysinfos_t *sysinfos);

/* get the current informations about the system,
   return a pointer to the sysinfos global variable */
sysinfos_t *
get_sysinfos(void);

/* one other global variable, if my teachers read this someday, they will became scary */
extern sysinfos_t sysinfos;

#endif /* _FBGETTY_SYSINFOS_H_ */
