from distutils.core import setup
from DistUtilsExtra.command import *
import glob
import os
import re

# look/set what version we have
changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)

setup(
    name = 'feisty-gdm-themes',
    version = version,
    data_files=[('share/gdm/themes/HumanFeisty', 
                 glob.glob('Human/*.png')+glob.glob('Human/*.svg')+\
		 glob.glob('Human/*.xml')),
                ('share/gdm/themes/HumanFeisty/gtk-2.0', glob.glob('Human/gtk-2.0/*')),
                ('share/gdm/themes/HumanCircleFeisty', 
		 glob.glob('HumanCircle/*.png')+glob.glob('HumanCircle/*.svg')+\
		 glob.glob('HumanCircle/*.xml')),
		('share/gdm/themes/HumanListFeisty',
                 glob.glob('HumanList/*.png')+glob.glob('HumanList/*.svg')+\
                 glob.glob('HumanList/*.xml')),
                ('share/gdm/themes/HumanListFeisty/gtk-2.0', glob.glob('HumanList/gtk-2.0/*')),
               ],
    cmdclass = { "build" : build_extra.build_extra,
                 "build_i18n" :  build_i18n.build_i18n }
)

