/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  sys_Sys_FileStream.c */
/* class: FileStream */

#include <ferite.h>       /* we need this without a doubt */
#include "sys_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( sys_Sys_FileStream_flock_nn )
{
   double shared;
   double wait;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, &shared, &wait, &super, &self );

   { /* Main function body. */
#line 1265 "posix.fec"

       
#ifdef HAVE_FLOCK
           int op;

	   if((int)shared) op = LOCK_SH;
	   else op = LOCK_EX;

           if(!(int)wait) op |= LOCK_NB;

           if(flock((int)SelfObj->filedata, op)) {
	       if(errno == EWOULDBLOCK) FE_RETURN_LONG(1);
               ferite_set_error(script, errno, "%s", strerror(errno));
               FE_RETURN_LONG(-1);
           } else FE_RETURN_LONG(0);
#else
           ferite_set_error(script, EINVAL, "flock() is not supported by this "
	   								"OS");
	   FE_RETURN_LONG(-1);
#endif
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream_unlock_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 1296 "posix.fec"

       
#ifdef HAVE_FLOCK
           if(flock((int)SelfObj->filedata, LOCK_UN)) {
               ferite_set_error(script, errno, "%s", strerror(errno));
               FE_RETURN_FALSE;
           } else FE_RETURN_TRUE;
#else
           ferite_set_error(script, EINVAL, "flock() is not supported by this "
	   								"OS");
	   FE_RETURN_LONG(-1);
#endif
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream_stat_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 1201 "posix.fec"

       
           struct stat *in;
           stream_flush( script, self );
           in = fmalloc( sizeof( struct stat ) );
           if( fstat( (int)SelfObj->filedata, in ) == -1 )
           {
               ferite_set_error( script, errno, "%s", strerror( errno ) );
               FE_RETURN_NULL_OBJECT;
           }
           FE_RETURN_VAR( system_call_stat( script, in ) );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream_pos_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 1183 "posix.fec"

       
           int retval;
           stream_flush( script, self );
           retval = lseek( (int)SelfObj->filedata, 0, SEEK_CUR );
           if( retval == -1 )
           {
               ferite_set_error( script, errno, "%s", strerror( errno ) );
               SelfObj->errmsg = fstrdup( strerror( errno ) );
           }
           FE_RETURN_LONG( retval );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream_getDescriptor_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 1361 "posix.fec"

       
           FE_RETURN_LONG((int)SelfObj->filedata);
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream___read___n )
{
   double c;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &c, &super, &self );

   { /* Main function body. */
#line 1310 "posix.fec"

       
           FeriteVariable *in;
           in = fe_new_str_static("read", NULL, (int)c, FE_CHARSET_DEFAULT );
           FE_STRLEN(in) = read( (int)SelfObj->filedata, FE_STR2PTR(in), (int)c );
           SelfObj->eos = FE_STRLEN(in);
           if( FE_STRLEN(in) == -1 )
           {
               ferite_set_error( script, errno, "%s", strerror( errno ) );
               if( SelfObj->errmsg != NULL )
               {
                   ffree( SelfObj->errmsg );
               }
               SelfObj->errmsg = fstrdup( strerror( errno ) );
               FE_STRLEN(in) = 0;
           }
           FE_RETURN_VAR( in );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream_length_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 1219 "posix.fec"

       
           off_t offset,length;

           stream_flush( script, self );
           offset = lseek( (int)SelfObj->filedata, 0, SEEK_CUR );
           if( offset == -1 )
           {
               ferite_set_error( script, errno, "%s", strerror( errno ) );
               SelfObj->errmsg = fstrdup( strerror( errno ) );
               FE_RETURN_LONG( -1 );
           }
           length = lseek( (int)SelfObj->filedata, 0, SEEK_END );
           lseek( (int)SelfObj->filedata, offset, SEEK_SET );
           FE_RETURN_LONG( length );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream_truncate_n )
{
   double length;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &length, &super, &self );

   { /* Main function body. */
#line 1139 "posix.fec"

       
           int retval;
           stream_flush( script, self );
           retval = ftruncate( (int)SelfObj->filedata, (off_t)length );
           if( retval == -1)
           {
               ferite_set_error( script, errno, "%s", strerror( errno ) );
               SelfObj->errmsg = fstrdup( strerror( errno ) );
               FE_RETURN_FALSE;
           }
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream___close___ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 1344 "posix.fec"

       
           if( (int)SelfObj->filedata != -1 )
             close( (int)SelfObj->filedata );
           (int)SelfObj->filedata = -1;
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream_seek_nn )
{
   double offset;
   double whence;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, &offset, &whence, &super, &self );

   { /* Main function body. */
#line 1164 "posix.fec"

       
           int retval;
           stream_flush( script, self );
           retval = lseek( (int)SelfObj->filedata, (off_t)offset, (int)whence );
           if( retval == -1)
           {
               ferite_set_error( script, errno, "%s", strerror( errno ) );
               SelfObj->errmsg = fstrdup( strerror( errno ) );
               FE_RETURN_LONG(retval);
           }
           FE_RETURN_LONG(retval);
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream_FileStream_n )
{
   double fd;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &fd, &super, &self );

   { /* Main function body. */
#line 1122 "posix.fec"

       
           FeriteVariable **args;
           args = ferite_create_parameter_list_from_data( script, "oo", self, self );
           ferite_variable_destroy( script, ferite_object_call_super( script, self, args ) );
           ferite_delete_parameter_list( script, args );
           SelfObj->filedata = (void *)(long)fd;
           SelfObj->read = ferite_find_function_in_object( script, self, "__read__" );
           SelfObj->write = ferite_find_function_in_object( script, self, "__write__" );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_FileStream___write___s )
{
   FeriteString *s;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &s, &super, &self );

   { /* Main function body. */
#line 1328 "posix.fec"

       
           int ret;
           ret = write( (int)SelfObj->filedata, s->data, s->length );
           if( ret == -1 )
           {
               ferite_set_error( script, errno, "%s", strerror( errno ) );
               if( SelfObj->errmsg != NULL )
               {
                   ffree( SelfObj->errmsg );
               }
               SelfObj->errmsg = fstrdup( strerror( errno ) );
               FE_RETURN_LONG( 0 );
           }
           FE_RETURN_LONG( ret );
       
   }
   FE_RETURN_VOID;
}

