#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/select.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>
#include <dirent.h>
#include <time.h>
#include <syslog.h>
#include <pwd.h>
#include <utime.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/resource.h>
#include "../../config.h"
#include "ferite.h"

#define SelfStat ((struct stat *)(self->odata))
#define ENDOFLINE "\n"

extern int errno;

struct FeTm
{
    FeriteVariable *tm_sec;
    FeriteVariable *tm_min;
    FeriteVariable *tm_hour;
    FeriteVariable *tm_mday;
    FeriteVariable *tm_mon;
    FeriteVariable *tm_year;
    FeriteVariable *tm_wday;
    FeriteVariable *tm_yday;
    FeriteVariable *tm_isdst;
    FeriteVariable *tm_zone;
    FeriteVariable *tm_gmtoff;
};

struct alarm_data {
    FeriteFunction       *function;
    FeriteScript         *script;
    int                  interval;
    int                  recurring;
    int                  timeleft;
};
typedef struct alarm_data AlarmData;
void timer_sig_alarm( int );
#ifndef FE_SYS_ALARM_OWNER
extern AlarmData *currentAlarm;
#endif

FeriteVariable *system_call_stat( FeriteScript *script, struct stat *in );
FeriteVariable *system_call_tm( FeriteScript *script, struct tm *tm );
int system_sync_to_tm( struct FeTm *Tm, struct tm *tm );
int system_sync_to_FeTm( struct FeTm *Tm, struct tm *tm );
int make_fd_set(FeriteScript *script, FeriteUnifiedArray *array, fd_set *f);
int update_SelectResult(FeriteScript *script, FeriteObject *obj,
			FeriteUnifiedArray *inarray, char *vname, fd_set *f);
int set_signal_action(FeriteScript *script, int sig, void *action);
void ferite_signal_handler(int signal);
int add_signal_handler(FeriteScript *script, int signal, FeriteString *func,
							FeriteObject *obj);
void remove_signal_handler(FeriteScript *script, int signal);

#ifndef PF_LOCAL
#define PF_LOCAL PF_UNIX
#endif    
