#include "util_stream.h"

int stream_flush( FeriteScript *script, FeriteObject *self )
{
   FeriteVariable *str, *retval, **args;
   int written;

   /* Syscalls are expensive, CPU cycles are not ( atleast compared to Syscalls )
    * so we extract and build up one singel page of the buffer and then call __write__() */

   str = ferite_buffer_to_var( SelfObj->output_buffer );
   
   if( FE_STRLEN(str) == 0 ){
	  ferite_variable_destroy( script, str );
	  str = NULL;
   }
	 
   if( str == NULL )
     return 0;

   args = ferite_create_parameter_list( 4 );
   args[0] = str;
   MARK_VARIABLE_AS_DISPOSABLE(args[0]);

   args[1] = ferite_create_object_variable( script, "arg", FE_STATIC );
   VAO(args[1]) = self;
   VAO(args[1])->refcount++;
   MARK_VARIABLE_AS_DISPOSABLE(args[1]);

   args[2] = ferite_create_object_variable( script, "arg", FE_STATIC );
   VAO(args[2]) = self;
   VAO(args[2])->refcount++;
   MARK_VARIABLE_AS_DISPOSABLE(args[2]);

   retval = ferite_call_function( script, SelfObj->write, args );
   written = VAI(retval);
   ferite_delete_parameter_list( script, args );

   /* No, we don't handle errors just yet, or partial writes for that matter */
   ferite_variable_destroy( script, retval );
   ferite_buffer_delete( SelfObj->output_buffer );
   SelfObj->output_buffer = ferite_buffer_new( 0 );
   return written;
}
FeriteVariable *system_create_pointer_var( FeriteScript *script, char *name, void *ptr )
{
   FeriteVariable *pointer;
   FeriteClass *cls;
   if((cls = ferite_find_class( script, script->mainns, "Sys.PointerObject" )) != NULL)
   {
      pointer = ferite_build_object( script, cls );
      VAO(pointer)->odata = ptr;
      ffree( VAO(pointer)->name );
      VAO(pointer)->name = fstrdup( name );
      FE_RETURN_VAR( pointer );
   }
   FE_RETURN_NULL_OBJECT;
}
FeriteVariable *system_create_stream_object( FeriteScript *script, char *stream_class, FILE *f )
{
   FeriteClass *cls;
   FeriteVariable *object, **args;
   if((cls = ferite_find_class( script, script->mainns, stream_class )) != NULL)
   {
       args = ferite_create_parameter_list( 4 );
       args = ferite_add_to_parameter_list( args, system_create_pointer_var( script, "stdios", f ) );
       object = ferite_new_object( script, cls, args );
//       object = ferite_create_object_variable( script, "foo", FE_STATIC );
       ferite_delete_parameter_list( script, args );
       FE_RETURN_VAR( object );
   }
   FE_RETURN_NULL_OBJECT;
}
