#ifndef __FERITE_UTIL_STREAM__
#define __FERITE_UTIL_STREAM__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "ferite.h"
#define STREAM_READ_BUFFER 4096
#define SelfObj ((struct Stream *)(self->odata))

extern int errno;

struct Stream
{
   FeriteString input_buffer;
   FeriteBuffer *output_buffer;
   char *endofline;
   FeriteFunction *read;
   FeriteFunction *write;
   FeriteVariable **read_args;
   FeriteVariable **write_args;
   int aggressive;
   char *errmsg;
   char *filename;
   void *filedata;
   int eos;
   void *lock;
};

int stream_flush( FeriteScript *script, FeriteObject *self );
FeriteVariable *system_create_pointer_var( FeriteScript *script, char *name, void *ptr );
FeriteVariable *system_create_stream_object( FeriteScript *script, char *stream_class, FILE *f );

#define lock_object aphex_mutex_lock( SelfObj->lock )
#define unlock_object aphex_mutex_unlock( SelfObj->lock )

#endif /* __FERITE_UTIL_STREAM__ */
