#include <ferite.h>
#include "reflection_header.h"

void reflection_variable_get( FeriteScript *script, FeriteVariable *var )
{
    FeriteObject *object = var->accessors->odata;
    FeriteFunction *function = ferite_object_get_function( script, object, "get" );
    FeriteVariable *rval = NULL;
    void *a = var->accessors;

    FE_ENTER_FUNCTION;

    if( function != NULL )
    {
        rval = ferite_call_function( script, object, NULL, function, NULL );

        if( rval->type != F_VAR_VOID )
        {
            var->accessors = NULL;
            ferite_variable_destroy( script, ferite_op_assign( script, var, rval ) );
            var->accessors = a;
        }

        ferite_variable_destroy( script, rval );
    }

    FE_LEAVE_FUNCTION(NOWT);
}

void reflection_variable_set( FeriteScript *script, FeriteVariable *var, FeriteVariable *newvalue )
{
    FeriteObject *object = var->accessors->odata;
    FeriteFunction *function = ferite_object_get_function( script, object, "set" );
    FeriteVariable **plist = ferite_create_parameter_list( 4 );
    FeriteVariable *rval = NULL;
    void *a = var->accessors;

    FE_ENTER_FUNCTION;

    if( function != NULL )
    {
        plist = ferite_add_to_parameter_list( plist, ferite_duplicate_variable( script, newvalue, NULL ) );
        MARK_VARIABLE_AS_DISPOSABLE( plist[0] );
        rval = ferite_call_function( script, object, NULL, function, plist );

        if( rval->type != F_VAR_VOID )
        {
            var->accessors = NULL;
            ferite_variable_destroy( script, ferite_op_assign( script, var, rval ) );
            var->accessors = a;
        }

        ferite_variable_destroy( script, rval );
    }
    ferite_delete_parameter_list( script, plist );
    FE_LEAVE_FUNCTION(NOWT);
}

void reflection_variable_cleanup( FeriteScript *script, void *odata )
{
    FeriteObject *object = odata;
    FeriteFunction *function = ferite_object_get_function( script, object, "cleanup" );
    FeriteVariable *rval = NULL;

    FE_ENTER_FUNCTION;

    if( function != NULL )
    {
        rval = ferite_call_function( script, object, NULL, function, NULL );
        ferite_variable_destroy( script, rval );
    }
    object->refcount--;
    FE_LEAVE_FUNCTION(NOWT);
}
