#include <ferite.h>
#include "utility.h"

SerializeContex *Serialize_walk_init( FeriteScript *script )
{
    SerializeContex *ctx = fmalloc( sizeof( SerializeContex ) );
    ctx->buf = ferite_buffer_new( 0 );
    ctx->objects = ferite_create_stack( script, 100 );
    return ctx;
}
void Serialize_walk_deinit( FeriteScript *script, SerializeContex *ctx )
{
    if( ctx )
    {
        if( ctx->buf )
            ferite_buffer_delete( ctx->buf );
        if( ctx->objects )
            ferite_delete_stack( script, ctx->objects );
        ffree( ctx );
    }
}

int Serialize_walk_native( FeriteScript *script, SerializeContex *ctx, FeriteVariable *v, int level )
{
    FeriteIterator iter;
    FeriteHashBucket *buk;    
    int i;
    
    if( level >= 99 )
    {
        ferite_error( script, 0, "Serializing too deeply nested" );
        return 0;
    }
    
    switch( v->type )
    {
        case F_VAR_LONG:
            ferite_buffer_printf( ctx->buf, "%d:%d:%s:%d\n", F_VAR_LONG, strlen(v->name), v->name, VAI(v) );
            break;
        case F_VAR_DOUBLE:
            ferite_buffer_printf( ctx->buf, "%d:%d:%s:%f\n", F_VAR_DOUBLE, strlen(v->name), v->name, VAF(v) );
            break;
        case F_VAR_STR:
            ferite_buffer_printf(ctx->buf, "%d:%d:%s:%d:", F_VAR_STR, strlen(v->name), v->name, FE_STRLEN(v) );
            ferite_buffer_add( ctx->buf, FE_STR2PTR(v), FE_STRLEN(v) );
            ferite_buffer_add_char( ctx->buf, '\n' );
            break;
        case F_VAR_OBJ:
            if( VAO( v ) == NULL )
            {
                /* This is an empty object */
                ferite_buffer_printf( ctx->buf, "%d:%d:%s:0:\n", F_VAR_OBJ, strlen(v->name),v->name );
            }
            else
            {
                FeriteFunction *func = NULL;
                func = ferite_object_get_function_for_params( script, VAO( v ), "serializeSleep", NULL );
                if( func != NULL ) 
                {
                    ferite_variable_destroy( script, ferite_call_function( script, v, NULL, func, NULL) );
                }
		
                if( (i = Serialize_walk_objects( script, ctx, v )) == -1 )
                {
                    char *klassName = ferite_generate_class_fqn( script, VAO(v)->klass );
                    ferite_stack_push( ctx->objects, VAO( v ) );
                    ferite_buffer_printf( ctx->buf, "%d:%d:%s:%d:%s\n", F_VAR_OBJ, strlen(v->name), v->name, strlen(klassName), klassName );
                    memset( &iter, 0, sizeof( FeriteIterator ) );
                    while( VAO( v ) && (buk = ferite_hash_walk( script, VAO(v)->variables->variables, &iter )) != NULL )
                    {
                        /* Recursive walk on non-empty objects */
                        Serialize_walk_native( script, ctx, (FeriteVariable *)buk->data, level+1 );
                    }
                    ferite_buffer_add( ctx->buf, "0:0::\n", 6 );
                }
                else
                {
                    /* This is a reference to an object */
                    ferite_buffer_printf( ctx->buf ,"-1:%d:%s:%d\n", strlen(v->name),v->name, i );
                }
            }
            break;
        case F_VAR_UARRAY:
            ferite_buffer_printf( ctx->buf, "%d:%d:%s\n", F_VAR_UARRAY, strlen(v->name), v->name );
            for( i = 0; i < VAUA(v)->size; i++ )
            {
                /* Recursive walk on arrays */
                Serialize_walk_native(script, ctx, VAUA(v)->array[i],level+1);
            }
                ferite_buffer_add(ctx->buf, "0:0::\n", 6 );
            break;
            
    }
    if( level == 0 )
    {
        /* FIXME: add crc or token that the buffer has ended */
        return 0;
    }
    return 1;
}
int Serialize_walk_XML( FeriteScript *script, SerializeContex *ctx, FeriteVariable *v, int level )
{
    FeriteIterator iter;
    FeriteHashBucket *buk;
    int i;
    char tab[101];
    
    if( level >= 99 )
    {
        ferite_error( script, 0, "Serializing too deeply" );
        return 0;
    }
    memset( tab, '\t', level + 1 );
    switch( v->type )
    {
        case F_VAR_LONG:
            ferite_buffer_printf( ctx->buf, "%.*s<%s type=\"long\">%d</%s>\n",level,tab, v->name, VAI(v), v->name );
            break;
        case F_VAR_DOUBLE:
            ferite_buffer_printf( ctx->buf, "%.*s<%s type=\"long\">%f</%s>\n",level,tab, v->name, VAF(v), v->name );
            break;
        case F_VAR_STR:
            ferite_buffer_printf( ctx->buf, "%.*s<%s type=\"string\">", level, tab, v->name );
            ferite_buffer_add( ctx->buf, FE_STR2PTR(v), FE_STRLEN(v) );
            ferite_buffer_printf( ctx->buf, "</%s>\n", v->name );
            break;
        case F_VAR_OBJ:
            if( VAO( v ) == NULL )
            {
                /* This is an empty object */
                ferite_buffer_printf( ctx->buf, "%.*s<%s type=\"object\" name=\"null\"></%s>\n", level, tab, v->name, v->name );
            }
            else
            {
                FeriteFunction *func = NULL;
                func = ferite_object_get_function_for_params( script, VAO( v ), "serializeSleep", NULL );
                if( func != NULL ) 
                {
                    ferite_variable_destroy( script, ferite_call_function( script, v, NULL, func, NULL) );
                }
		
                if( (i = Serialize_walk_objects( script, ctx, v )) == -1 )
                {
                    ferite_buffer_printf( ctx->buf, "%.*s<%s type=\"object\" name=\"%s\">\n", level, tab, v->name, VAO(v)->name );
                    memset( &iter, 0, sizeof( FeriteIterator ) );
                    while( VAO( v ) && (buk = ferite_hash_walk( script, VAO(v)->variables->variables, &iter )) != NULL )
                    {
                        /* Recursive walk on non-empty objects */
                        Serialize_walk_XML( script, ctx, (FeriteVariable *)buk->data, level+1 );
                    }
                    ferite_buffer_printf( ctx->buf, "%.*s</%s>\n", level, tab, v->name );
                }
                else
                {
                    ferite_buffer_printf( ctx->buf, "%.*s<%s type=\"reference\">%d</%s>\n",
                                          level, tab, v->name, i, v->name );
                }
            }
            break;
        case F_VAR_UARRAY:
            ferite_buffer_printf( ctx->buf, "%.*s<%s type=\"array\">\n",level,tab, v->name );
            for( i = 0; i < VAUA(v)->size; i++ )
            {
                /* Recursive walk on arrays */
                Serialize_walk_XML(script, ctx, VAUA(v)->array[i],level+1 );
            }
                ferite_buffer_printf( ctx->buf, "%.*s</%s>\n", level, tab, v->name );
            break;
    }
    if( level == 0 )
        return 0;
}
int Serialize_walk_objects( FeriteScript *script, SerializeContex *ctx, FeriteVariable *v )
{
    int i;
    for( i = 0; i <= ctx->objects->stack_ptr ; i++ )
    {
        
        if( (FeriteObject *)ctx->objects->stack[i] == VAO( v ) )
        {
            return i;
        }
    }
    return -1;
}
int Serialize_native_decode_first( FeriteScript *script, char **str, int *type, int *len, int level )
{
    char *ptr;
    
    if( level >= 99 )
    {
        ferite_error( script, 0, "Structure is too deeply nested" );
        return 1;
    }
    ptr = Serialize_strsep( str, ":" );
    if( ptr == NULL )
    {
        ferite_error( script, 0, "Corrupted serialized data:no type field" );
        return 2;
    }
    *type = atoi( ptr );
    ptr = Serialize_strsep( str, ":" );
    if( ptr == NULL )
    {
        ferite_error( script, 0, "Corrupted serialized data:no length field" );
        return 3;
    }
    *len = atoi( ptr );
    return 0;
}
char *Serialize_strsep( register char **stringp , register const char *delim )
{
    register char *s;
    register const char *spanp;
    register int c, sc;
    char *tok;
    
    if ((s = *stringp) == NULL)
        return (NULL);
    for (tok = s;;)
    {
        c = *s++;
        spanp = delim;
        do
        {
            if ((sc = *spanp++) == c)
            {
                if (c == 0)
                    s = NULL;
                else
                    s[-1] = 0;
                *stringp = s;
                return (tok);
            }
        }
        while (sc != 0);
    }
}

