/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  sys_Network_UDPSocket.c */
/* class: UDPSocket */

#include <ferite.h>       /* we need this without a doubt */
#include "sys_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_sys_Network_UDPSocket_sendTo_snns )
{
   FeriteString *host;
   double port;
   double af;
   FeriteString *dgram;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 4, &host, &port, &af, &dgram );

   { /* Main function body. */
#line 1084 "network.fec"

       
           struct sockaddr *sa;
           int size, family = (int)af;
           FeriteVariable *fv, *fv2;

           if(!(sa = make_sockaddr(script, host->data, (short)port, &family,
                                   &size)))
           {
               FE_RETURN_FALSE;
           }

           fv = ferite_object_get_var(script, self, "sock");
           fv2 = ferite_object_get_var(script, self, "af");
           if(VAI(fv) == -1)
           {
               if((VAI(fv) = socket(family, SOCK_DGRAM, 0)) == -1)
               {
                   ferite_set_error(script, errno, "%s", strerror(errno));
                   ffree(sa);
                   FE_RETURN_FALSE;
               }
               if(family == AF_INET) VAI(fv2) = 0;
               else VAI(fv2) = 1;
           }
           else
           {
               if(VAI(fv2) != (long)af)
               {
                   ferite_set_error(script, EEXIST, "Socket already exists "
                                    "with a different address family");
                   ffree(sa);
                   FE_RETURN_FALSE;
               }
           }

           if(sendto(VAI(fv), dgram->data, dgram->length, 0, sa, size) == -1)
           {
               ferite_set_error(script, errno, "%s", strerror(errno));
               ffree(sa);
               FE_RETURN_FALSE;
           }

           ffree(sa);

           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_UDPSocket_recv_n )
{
   double maxlen;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &maxlen );

   { /* Main function body. */
#line 1192 "network.fec"

       
           int len;
           char *buf;
#ifdef ENABLE_IPV6
           int rlen = sizeof(struct sockaddr_in6);
           unsigned char rbuf[sizeof(struct sockaddr_in6)];
#else
           int rlen = sizeof(struct sockaddr_in);
           unsigned char rbuf[sizeof(struct sockaddr_in)];
#endif
           FeriteVariable *fv = ferite_object_get_var(script, self, "sock");

           ferite_set_error(script, 0, "");

           if(VAI(fv) == -1 || ((int)maxlen < 1) ||
              !(buf = fmalloc((int)maxlen)))
           {
               ferite_set_error(script, EINVAL, "Invalid arguments to recv()");
               fv = ferite_create_string_variable_from_ptr(script, "", "", 0,
                                                           FE_CHARSET_DEFAULT, FE_STATIC);
               FE_RETURN_VAR(fv);
           }

           if((len = recvfrom(VAI(fv), buf, (int)maxlen, 0,
                              (struct sockaddr *)rbuf, &rlen)) == -1)
           {
               ferite_set_error(script, errno, "%s", strerror(errno));
               ffree(buf);
               fv = ferite_create_string_variable_from_ptr(script, "", "", 0,
                                                           FE_CHARSET_DEFAULT, FE_STATIC);
               FE_RETURN_VAR(fv);
           }

           fv = ferite_object_get_var(script, self, "af");
           set_remoteip(script, self, (struct sockaddr *)rbuf, VAI(fv));

           fv = ferite_create_string_variable_from_ptr(script, "", buf, len,
                                                       FE_CHARSET_DEFAULT, FE_STATIC);

           ffree(buf);

           FE_RETURN_VAR(fv);
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_UDPSocket_close_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 1242 "network.fec"

       
           FeriteVariable *fv = ferite_object_get_var(script, self, "sock");
           if(VAI(fv) != -1)
           {
               close(VAI(fv));
               VAI(fv) = -1;
           }
           fv = ferite_object_get_var(script, self, "_conn");
           VAI(fv) = 0;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_UDPSocket_send_s )
{
   FeriteString *dgram;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &dgram );

   { /* Main function body. */
#line 1149 "network.fec"

       
           FeriteVariable *fv = ferite_object_get_var(script, self, "sock");
           FeriteVariable *fv2 = ferite_object_get_var(script, self, "_conn");

           if(VAI(fv) == -1 || !VAI(fv2))
           {
               ferite_set_error(script, ENOENT, "Socket not connected");
               FE_RETURN_FALSE;
           }

           if(send(VAI(fv), dgram->data, dgram->length, 0) == -1)
           {
               ferite_set_error(script, errno, "%s", strerror(errno));
               FE_RETURN_FALSE;
           }
           else FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_UDPSocket_destructor_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 905 "network.fec"

       
           FeriteVariable *fv = ferite_object_get_var(script, self, "sock");
           if(VAI(fv) != -1) close(VAI(fv));
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_UDPSocket_connect_snn )
{
   FeriteString *host;
   double port;
   double af;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 3, &host, &port, &af );

   { /* Main function body. */
#line 1007 "network.fec"

       
           struct sockaddr *sa;
           int size, family = (int)af;
           FeriteVariable *fv, *fv2;

           if(!(sa = make_sockaddr(script, host->data, (short)port, &family,
                                   &size)))
           {
               FE_RETURN_FALSE;
           }

           fv = ferite_object_get_var(script, self, "sock");
           fv2 = ferite_object_get_var(script, self, "af");
           if(VAI(fv) == -1)
           {
               if((VAI(fv) = socket(family, SOCK_DGRAM, 0)) == -1)
               {
                   ferite_set_error(script, errno, "%s", strerror(errno));
                   ffree(sa);
                   FE_RETURN_FALSE;
               }
               if(family == AF_INET) VAI(fv2) = 0;
               else VAI(fv2) = 1;
           }
           else
           {
               if((VAI(fv2) == 0 && family == AF_INET6) ||
                  (VAI(fv2) == 1 && family == AF_INET))
               {
                   ferite_set_error(script, EEXIST, "Socket already exists "
                                    "with a different address family");
                   ffree(sa);
                   FE_RETURN_FALSE;
               }
           }

           if(connect(VAI(fv), sa, size))
           {
               ferite_set_error(script, errno, "%s", strerror(errno));
               ffree(sa);
               FE_RETURN_FALSE;
           }

           ffree(sa);

           fv = ferite_object_get_var(script, self, "_conn");
           VAI(fv) = 1;

           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Network_UDPSocket_bind_snn )
{
   FeriteString *host;
   double port;
   double af;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 3, &host, &port, &af );

   { /* Main function body. */
#line 933 "network.fec"

       
           struct sockaddr *sa;
           int size, family = (int)af;
           FeriteVariable *fv = ferite_object_get_var(script, self, "sock");

           if(VAI(fv) != -1)
           {
               ferite_set_error(script, EEXIST, "Socket already exists");
               FE_RETURN_FALSE;
           }

           if(!(sa = make_sockaddr(script, host->data, (short)port, &family,
                                   &size)))
           {
               FE_RETURN_FALSE;
           }

           if((VAI(fv) = socket(family, SOCK_DGRAM, 0)) == -1)
           {
               ferite_set_error(script, errno, "%s", strerror(errno));
               ffree(sa);
               FE_RETURN_FALSE;
           }

           if(bind(VAI(fv), sa, size))
           {
               ferite_set_error(script, errno, "%s", strerror(errno));
               ffree(sa);
               close(VAI(fv));
               VAI(fv) = -1;
               FE_RETURN_FALSE;
           }

           fv = ferite_object_get_var(script, self, "af");
           if(family == AF_INET) VAI(fv) = 0;
           else VAI(fv) = 1;

           ffree(sa);

           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

