/*
 * Decompiled with CFR 0.152.
 */
package thredds.viewer.gis;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import thredds.ui.BAMutil;
import thredds.ui.PopupMenu;
import thredds.viewer.gis.shapefile.ShapeFileBean;
import thredds.viewer.gis.worldmap.WorldMapBean;
import thredds.viewer.ui.Renderer;

public abstract class MapBean {
    private EventListenerList listenerList = new EventListenerList();

    public abstract ImageIcon getIcon();

    public abstract String getActionName();

    public abstract String getActionDesc();

    public abstract Renderer getRenderer();

    public Action getAction() {
        AbstractAction useMap = new AbstractAction(this.getActionName(), this.getIcon()){

            public void actionPerformed(ActionEvent e) {
                MapBean.this.firePropertyChangeEvent(this, "Renderer", null, MapBean.this.getRenderer());
            }
        };
        useMap.putValue("ShortDescription", this.getActionDesc());
        return useMap;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    protected void firePropertyChangeEvent(Object source, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
        this.firePropertyChangeEvent(event);
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    public static PopupMenu makeMapSelectButton() {
        AbstractAction mapSelectAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties(mapSelectAction, "WorldMap", "select map", false, 77, -1);
        AbstractButton mapSelectButton = BAMutil.makeButtconFromAction(mapSelectAction);
        PopupMenu mapPopup = new PopupMenu(mapSelectButton, "Select Map", true);
        return mapPopup;
    }

    public static PopupMenu getStandardMapSelectButton(PropertyChangeListener pcl) {
        PopupMenu mapBeanMenu = MapBean.makeMapSelectButton();
        ArrayList<MapBean> standardMaps = new ArrayList<MapBean>();
        standardMaps.add(new WorldMapBean());
        standardMaps.add(new ShapeFileBean("WorldDetailMap", "Global Detailed Map", "WorldDetailMap", "/optional/nj22/maps/Countries.zip"));
        standardMaps.add(new ShapeFileBean("USDetailMap", "US Detailed Map", "USMap", "/optional/nj22/maps/US.zip"));
        for (int i = 0; i < standardMaps.size(); ++i) {
            MapBean mb = (MapBean)standardMaps.get(i);
            mapBeanMenu.addAction(mb.getActionDesc(), mb.getIcon(), mb.getAction());
            mb.addPropertyChangeListener(pcl);
        }
        return mapBeanMenu;
    }
}

