/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import visad.data.DataCacheManager;
import visad.util.Util;

public class ArrayCache {
    private boolean enabled = Boolean.parseBoolean(System.getProperty("visad.data.arraycache.enabled", "true"));
    private int lowerThreshold = Integer.parseInt(System.getProperty("visad.data.arraycache.lowerthreshold", "1000"));
    private int upperThreshold = Integer.parseInt(System.getProperty("visad.data.arraycache.upperthreshold", "1000000"));
    private boolean useDataCacheManager = Boolean.parseBoolean(System.getProperty("visad.data.arraycache.usedatacachemanager", "false"));
    private Hashtable<String, Integer> misses = new Hashtable();
    private Hashtable<Object, Object> map = new Hashtable();

    public ArrayCache() {
    }

    public ArrayCache(boolean enabled) {
        this.enabled = enabled;
    }

    private String getKey(String key, int size) {
        return key + "_" + size;
    }

    public FloatResult get(String key, float[][] input) {
        if (!this.shouldHandle(input)) {
            return new FloatResult(false);
        }
        return this.getInner(key, input);
    }

    private synchronized FloatResult getInner(String key, float[][] input) {
        float[][][] pair = this.getFloatValue(key = this.getKey(key, input[0].length));
        if (pair == null) {
            return this.handleCacheMiss(key, input);
        }
        float[][] lastInput = pair[0];
        float[][] lastOutput = pair[1];
        if (lastInput.length != input.length) {
            return null;
        }
        for (int i = 0; i < input.length; ++i) {
            if (Arrays.equals(input[i], lastInput[i])) continue;
            return this.handleCacheMiss(key, input);
        }
        this.misses.remove(key);
        return new FloatResult(Util.clone(lastOutput));
    }

    public DoubleResult get(String key, double[][] input) {
        if (!this.shouldHandle(input)) {
            return new DoubleResult(false);
        }
        return this.getInner(key, input);
    }

    private synchronized DoubleResult getInner(String key, double[][] input) {
        double[][][] pair = this.getDoubleValue(key = this.getKey(key, input[0].length));
        if (pair == null) {
            return this.handleCacheMiss(key, input);
        }
        double[][] lastInput = pair[0];
        double[][] lastOutput = pair[1];
        if (lastInput.length != input.length) {
            return null;
        }
        for (int i = 0; i < input.length; ++i) {
            if (Arrays.equals(input[i], lastInput[i])) continue;
            return this.handleCacheMiss(key, input);
        }
        this.misses.remove(key);
        return new DoubleResult(Util.clone(lastOutput));
    }

    private DoubleResult handleCacheMiss(String key, double[][] input) {
        Integer numMisses = this.misses.get(key);
        if (numMisses == null) {
            numMisses = new Integer(1);
            this.misses.put(key, numMisses);
        } else {
            this.misses.put(key, new Integer(numMisses + 1));
        }
        if (numMisses > 3) {
            this.removeValue(key);
        }
        return new DoubleResult(numMisses <= 1);
    }

    private FloatResult handleCacheMiss(String key, float[][] input) {
        Integer numMisses = this.misses.get(key);
        if (numMisses == null) {
            numMisses = new Integer(1);
            this.misses.put(key, numMisses);
        } else {
            this.misses.put(key, new Integer(numMisses + 1));
        }
        if (numMisses > 3) {
            this.removeValue(key);
        }
        return new FloatResult(numMisses <= 1);
    }

    private boolean shouldHandle(double[][] input) {
        if (input == null) {
            return false;
        }
        if (input.length == 0) {
            return false;
        }
        if (input[0] == null) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        if (input[0].length <= this.lowerThreshold) {
            return false;
        }
        return input[0].length <= this.upperThreshold;
    }

    private boolean shouldHandle(float[][] input) {
        if (input == null) {
            return false;
        }
        if (input.length == 0) {
            return false;
        }
        if (input[0] == null) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        if (input[0].length <= this.lowerThreshold) {
            return false;
        }
        return input[0].length <= this.upperThreshold;
    }

    public void put(String key, double[][] input, DoubleResult results) {
        if (!this.shouldHandle(input)) {
            return;
        }
        this.putInner(key, input, results);
    }

    private synchronized void putInner(String key, double[][] input, DoubleResult results) {
        if (!results.shouldCache || results.values == null) {
            return;
        }
        key = this.getKey(key, input[0].length);
        this.storeValue(key, new double[][][]{Util.clone(input), Util.clone(results.values)});
    }

    public void put(String key, float[][] input, FloatResult results) {
        if (!this.shouldHandle(input)) {
            return;
        }
        this.putInner(key, input, results);
    }

    private synchronized void putInner(String key, float[][] input, FloatResult results) {
        if (!results.shouldCache || results.values == null) {
            return;
        }
        key = this.getKey(key, input[0].length);
        this.storeValue(key, new float[][][]{Util.clone(input), Util.clone(results.values)});
    }

    private void storeValue(String key, double[][][] value) {
        this.checkCache();
        Object object = value;
        if (this.useDataCacheManager) {
            this.removeValue(key);
            object = DataCacheManager.getCacheManager().addToCache("ArrayCache", value, true);
        }
        this.map.put(key, object);
    }

    private void storeValue(String key, float[][][] value) {
        this.checkCache();
        Object object = value;
        if (this.useDataCacheManager) {
            this.removeValue(key);
            object = DataCacheManager.getCacheManager().addToCache("ArrayCache", value, true);
        }
        this.map.put(key, object);
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.useDataCacheManager) {
            this.clearCache();
        }
    }

    private void checkCache() {
        if (this.map.size() > 4) {
            this.clearCache();
        }
    }

    private void removeValue(Object key) {
        Object object = this.map.get(key);
        if (object != null) {
            if (this.useDataCacheManager) {
                DataCacheManager.getCacheManager().removeFromCache(object);
            }
            this.map.remove(key);
        }
    }

    private void clearCache() {
        Enumeration<Object> keys = this.map.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object object = this.map.get(key);
            if (!this.useDataCacheManager) continue;
            DataCacheManager.getCacheManager().removeFromCache(object);
        }
        this.map = new Hashtable();
    }

    private double[][][] getDoubleValue(String key) {
        Object object = this.map.get(key);
        if (object == null) {
            return null;
        }
        if (this.useDataCacheManager) {
            return DataCacheManager.getCacheManager().getDoubleArray3D(object);
        }
        return (double[][][])object;
    }

    private float[][][] getFloatValue(String key) {
        Object object = this.map.get(key);
        if (object == null) {
            return null;
        }
        if (this.useDataCacheManager) {
            return DataCacheManager.getCacheManager().getFloatArray3D(object);
        }
        return (float[][][])object;
    }

    public static class FloatResult {
        public boolean shouldCache = true;
        public float[][] values;

        public FloatResult() {
            this.shouldCache = false;
            this.values = null;
        }

        public FloatResult(boolean shouldCache) {
            this.shouldCache = shouldCache;
        }

        public FloatResult(float[][] values) {
            this.values = values;
            this.shouldCache = true;
        }

        public float[][] cloneForCache(float[][] a) {
            if (!this.shouldCache) {
                return null;
            }
            return Util.clone(a);
        }

        public boolean getShouldCache() {
            return this.shouldCache;
        }
    }

    public static class DoubleResult {
        public boolean shouldCache = true;
        public double[][] values;

        public DoubleResult() {
            this.shouldCache = false;
            this.values = null;
        }

        public DoubleResult(boolean shouldCache) {
            this.shouldCache = shouldCache;
        }

        public DoubleResult(double[][] values) {
            this.values = values;
            this.shouldCache = true;
        }

        public double[][] cloneForCache(double[][] a) {
            if (!this.shouldCache) {
                return null;
            }
            return Util.clone(a);
        }

        public boolean getShouldCache() {
            return this.shouldCache;
        }
    }
}

