/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.CacheStrategy;
import visad.data.FileFlatField;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryAccessor;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDataArray;
import visad.data.visad.object.BinaryDoubleMatrix;
import visad.data.visad.object.BinaryFunctionType;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryFlatField
implements BinaryObject {
    private static CacheStrategy strategy = new CacheStrategy();

    public static final int computeBytes(Set domainSet, CoordinateSystem cs, CoordinateSystem[] rangeCS, Set[] rangeSets, Unit[] units, FlatField fld) {
        int rangeSetsLen;
        int samplesLen = 0;
        if (!fld.isMissing()) {
            int dim = fld.getRangeDimension();
            int len = fld.getLength();
            if (dim > 0 && len > 0) {
                samplesLen = 4 + dim * (4 + len * 8);
            }
        }
        if (rangeSets == null) {
            rangeSetsLen = 0;
        } else {
            rangeSetsLen = 5;
            for (int i = 0; i < rangeSets.length; ++i) {
                int len = BinaryGeneric.computeBytes(rangeSets[i]);
                if (len < 0) {
                    return -1;
                }
                rangeSetsLen += len;
            }
        }
        int unitsLen = BinaryUnit.computeBytes(units);
        return 10 + (domainSet == null ? 0 : 1 + BinaryGeneric.computeBytes(domainSet)) + samplesLen + (cs == null ? 0 : 5) + (rangeCS == null ? 0 : 1 + BinaryCoordinateSystem.computeBytes(rangeCS)) + rangeSetsLen + (unitsLen == 0 ? 0 : 1 + unitsLen) + 1;
    }

    private static FileFlatField createFileFlatField(BinaryReader rdr, int objLen) throws IOException, VisADException {
        long filePtr = rdr.getFilePointer();
        BinaryObjectCache typeCache = rdr.getTypeCache();
        DataInput file = rdr.getInput();
        int typeIndex = file.readInt();
        FunctionType ft = (FunctionType)typeCache.get(typeIndex);
        rdr.seek(filePtr + (long)objLen);
        return new FileFlatField(new BinaryAccessor(rdr, filePtr, ft), strategy);
    }

    private static final Set[] readSetArray(BinaryReader reader) throws IOException, VisADException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        Set[] sets = new Set[len];
        for (int i = 0; i < sets.length; ++i) {
            sets[i] = (Set)BinaryGeneric.read(reader);
        }
        return sets;
    }

    public static final FlatField read(BinaryReader reader, int objLen, boolean cacheFile) throws IOException, VisADException {
        if (cacheFile) {
            return BinaryFlatField.createFileFlatField(reader, objLen);
        }
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        long uTime = 0L;
        long slTime = 0L;
        long rcsTime = 0L;
        long icsTime = 0L;
        long dbTime = 0L;
        long dsTime = 0L;
        long sTime = 0L;
        long totStart = 0L;
        totStart = System.currentTimeMillis();
        int typeIndex = file.readInt();
        FunctionType ft = (FunctionType)typeCache.get(typeIndex);
        Set domainSet = null;
        Data[] oldSamples = null;
        CoordinateSystem cs = null;
        CoordinateSystem[] rangeCS = null;
        Set[] rangeSets = null;
        Unit[] units = null;
        double[][] samples = null;
        boolean reading = true;
        block12: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            long tmpStart = System.currentTimeMillis();
            switch (directive) {
                case 12: {
                    domainSet = (Set)BinaryGeneric.read(reader);
                    continue block12;
                }
                case 8: {
                    oldSamples = BinaryDataArray.read(reader);
                    continue block12;
                }
                case 7: {
                    samples = BinaryDoubleMatrix.read(reader);
                    continue block12;
                }
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    continue block12;
                }
                case 50: {
                    rangeCS = BinaryCoordinateSystem.readList(reader);
                    continue block12;
                }
                case 15: {
                    rangeSets = BinaryFlatField.readSetArray(reader);
                    continue block12;
                }
                case 40: {
                    units = BinaryUnit.readList(reader);
                    continue block12;
                }
                case 80: {
                    reading = false;
                    continue block12;
                }
            }
            throw new IOException("Unknown FlatField directive " + directive);
        }
        if (ft == null) {
            throw new IOException("No FunctionType found for FlatField");
        }
        long tmpStart = System.currentTimeMillis();
        FlatField fld = new FlatField(ft, domainSet, rangeCS, rangeSets, units);
        long c1Time = System.currentTimeMillis() - tmpStart;
        tmpStart = System.currentTimeMillis();
        if (samples != null) {
            fld.setSamples(0, samples);
        } else if (oldSamples != null) {
            int len = oldSamples.length;
            for (int i = 0; i < len; ++i) {
                fld.setSample(i, oldSamples[i]);
            }
        }
        long c2Time = System.currentTimeMillis() - tmpStart;
        tmpStart = System.currentTimeMillis();
        if (samples != null) {
            fld.setSamples(samples, false);
        }
        long c3Time = System.currentTimeMillis() - tmpStart;
        return fld;
    }

    public static final void writeDependentData(BinaryWriter writer, FunctionType type, Set domainSet, CoordinateSystem cs, CoordinateSystem[] rangeCS, Set[] rangeSets, Unit[] units, FlatField fld, Object token) throws IOException {
        if (!(fld.getClass().equals(FlatField.class) || fld.getClass().equals(FileFlatField.class) || fld instanceof FlatField && fld instanceof Saveable)) {
            return;
        }
        Object dependToken = token == SAVE_DEPEND_BIG ? token : SAVE_DEPEND;
        BinaryFunctionType.write(writer, type, SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, SAVE_DATA);
        }
        if (rangeCS != null) {
            BinaryCoordinateSystem.writeList(writer, rangeCS, SAVE_DATA);
        }
        if (units != null) {
            BinaryUnit.writeList(writer, units, SAVE_DATA);
        }
        if (domainSet != null) {
            BinaryGeneric.write(writer, domainSet, dependToken);
        }
        if (rangeSets != null) {
            for (int i = 0; i < rangeSets.length; ++i) {
                BinaryGeneric.write(writer, rangeSets[i], dependToken);
            }
        }
    }

    public static final void write(BinaryWriter writer, FunctionType type, Set domainSet, CoordinateSystem cs, CoordinateSystem[] rangeCS, Set[] rangeSets, Unit[] units, FlatField fld, Object token) throws IOException {
        BinaryFlatField.writeDependentData(writer, type, domainSet, cs, rangeCS, rangeSets, units, fld, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(fld.getClass().equals(FlatField.class) || fld.getClass().equals(FileFlatField.class) || fld instanceof FlatField && fld instanceof Saveable)) {
            BinaryUnknown.write(writer, fld, token);
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("FunctionType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        int[] csList = null;
        if (rangeCS != null) {
            csList = BinaryCoordinateSystem.lookupList(writer.getCoordinateSystemCache(), rangeCS);
        }
        int[] unitsIndex = null;
        if (units != null) {
            unitsIndex = BinaryUnit.lookupList(writer.getUnitCache(), units);
        }
        int objLen = BinaryFlatField.computeBytes(domainSet, cs, rangeCS, rangeSets, units, fld);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(21);
        file.writeInt(typeIndex);
        if (domainSet != null) {
            file.writeByte(12);
            BinaryGeneric.write(writer, domainSet, token);
        }
        if (!fld.isMissing() && fld.getLength() > 0) {
            double[][] dblSamples;
            try {
                dblSamples = fld.unpackValues();
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
                dblSamples = null;
            }
            catch (VisADException ve) {
                ve.printStackTrace();
                dblSamples = null;
            }
            if (dblSamples != null) {
                file.writeByte(7);
                BinaryDoubleMatrix.write(writer, dblSamples, token);
            }
        }
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        if (csList != null) {
            file.writeByte(50);
            BinaryIntegerArray.write(writer, csList, token);
        }
        if (rangeSets != null) {
            file.writeByte(15);
            file.writeInt(rangeSets.length);
            for (int i = 0; i < rangeSets.length; ++i) {
                BinaryGeneric.write(writer, rangeSets[i], token);
            }
        }
        if (unitsIndex != null) {
            file.writeByte(40);
            BinaryIntegerArray.write(writer, unitsIndex, token);
        }
        file.writeByte(80);
    }
}

